/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.internal.core.CallContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.MethodInvokeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.exceptions.NotAcceptableWebAppException;
import org.restlet.ext.jaxrs.internal.exceptions.RequestHandledException;
import org.restlet.ext.jaxrs.internal.exceptions.UnsupportedMediaTypeWebAppException;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.AbstractMethodWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethod;

public class ExceptionHandler {
    private static final String HEADER_ALLOW = "Allow";
    private final Logger logger;
    private volatile Restlet noResMethodHandler;
    private volatile Restlet noResourceClHandler;
    private volatile Restlet noRootResClHandler;

    private static Set<Variant> getSupportedVariants(Collection<ResourceMethod> supporting) {
        HashSet<Variant> supportedVariants = new HashSet<Variant>();
        for (ResourceMethod resourceMethod : supporting) {
            supportedVariants.addAll(resourceMethod.getSupportedVariants());
        }
        return supportedVariants;
    }

    public ExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    public WebApplicationException convertRepresentationExc(ConvertRepresentationException cre) throws WebApplicationException {
        Response.ResponseBuilder rb = javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST);
        StringWriter stw = new StringWriter();
        cre.printStackTrace(new PrintWriter(stw));
        rb.entity((Object)stw.toString());
        throw new WebApplicationException((Throwable)cre, rb.build());
    }

    public Restlet getNoResMethodHandler() {
        return this.noResMethodHandler;
    }

    public Restlet getNoResourceClHandler() {
        return this.noResourceClHandler;
    }

    public Restlet getNoRootResClHandler() {
        return this.noRootResClHandler;
    }

    public RequestHandledException instantiateExecption(InstantiateException exception, CallContext callContext, String logMessage) throws RequestHandledException {
        callContext.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        this.logger.log(Level.WARNING, logMessage, exception.getCause());
        throw new RequestHandledException();
    }

    public RequestHandledException methodInvokeException(MethodInvokeException exception, CallContext callContext, String logMessage) throws RequestHandledException {
        callContext.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        this.logger.log(Level.WARNING, logMessage, exception.getCause());
        throw new RequestHandledException();
    }

    public void methodNotAllowed(Set<Method> allowedMethods) throws WebApplicationException {
        Response.ResponseBuilder rb = javax.ws.rs.core.Response.status((int)Status.CLIENT_ERROR_METHOD_NOT_ALLOWED.getCode());
        rb.header(HEADER_ALLOW, (Object)Util.toString(allowedMethods, ", "));
        throw new WebApplicationException(rb.build());
    }

    public RequestHandledException missingAnnotation(MissingAnnotationException exception, CallContext callContext, String logMessage) throws RequestHandledException {
        callContext.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        if (exception != null) {
            logMessage = logMessage + ": " + exception.getMessage();
        }
        this.logger.log(Level.WARNING, logMessage);
        throw new RequestHandledException();
    }

    public WebApplicationException noMessageBodyWriter(Class<? extends Object> entityClass, Type genericType, Annotation[] annotations, MediaType respMediaType, SortedMetadata<MediaType> accMediaTypes) throws WebApplicationException {
        String warning = "No message body writer found for " + entityClass + "(generic type is " + genericType + ")";
        if (respMediaType != null) {
            warning = warning + "; response media type should be: " + respMediaType;
        }
        if (accMediaTypes != null) {
            warning = warning + "; accepted media types are: " + accMediaTypes;
        }
        this.logger.warning(warning);
        annotations.toString();
        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
    }

    public void noResourceMethodForAccMediaTypes(Collection<ResourceMethod> supporting) throws WebApplicationException {
        Set<Variant> supportedVariants = ExceptionHandler.getSupportedVariants(supporting);
        throw new NotAcceptableWebAppException(supportedVariants);
    }

    public WebApplicationException notAcceptableWhileDetermineMediaType() throws WebApplicationException {
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    public void resourceMethodNotFound() throws WebApplicationException, RequestHandledException {
        if (this.noResMethodHandler != null) {
            this.noResMethodHandler.handle(Request.getCurrent(), Response.getCurrent());
            throw new RequestHandledException();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    public void resourceNotFound() throws WebApplicationException, RequestHandledException {
        if (this.noResourceClHandler != null) {
            this.noResourceClHandler.handle(Request.getCurrent(), Response.getCurrent());
            throw new RequestHandledException();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    public void rootResourceNotFound() throws WebApplicationException, RequestHandledException {
        if (this.noRootResClHandler != null) {
            this.noRootResClHandler.handle(Request.getCurrent(), Response.getCurrent());
            throw new RequestHandledException();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    public RequestHandledException runtimeExecption(RuntimeException exception, AbstractMethodWrapper jaxRsMethod, CallContext callContext, String logMessage) throws RequestHandledException {
        callContext.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        if (jaxRsMethod != null) {
            logMessage = jaxRsMethod + ": " + logMessage;
        }
        this.logger.log(Level.WARNING, jaxRsMethod + ": " + logMessage, exception);
        throw new RequestHandledException();
    }

    public void setNoResMethodHandler(Restlet noResMethodHandler) {
        this.noResMethodHandler = noResMethodHandler;
    }

    public void setNoResourceClHandler(Restlet noResourceClHandler) {
        this.noResourceClHandler = noResourceClHandler;
    }

    public void setNoRootResClHandler(Restlet noRootResClHandler) {
        this.noRootResClHandler = noRootResClHandler;
    }

    public void unsupportedMediaType(Collection<ResourceMethod> accepting) throws WebApplicationException {
        Set<Variant> acceptedVariants = ExceptionHandler.getSupportedVariants(accepting);
        throw new UnsupportedMediaTypeWebAppException(acceptedVariants);
    }
}

