/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Header;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.util.Series;

public class JettyServerCall
extends ServerCall {
    private final HttpChannel<?> channel;
    private volatile boolean requestHeadersAdded;

    public JettyServerCall(Server server, HttpChannel<?> channel) {
        super(server);
        this.channel = channel;
        this.requestHeadersAdded = false;
    }

    public boolean abort() {
        this.getChannel().getEndPoint().close();
        return true;
    }

    public void complete() {
        try {
            this.getChannel().getResponse().flushBuffer();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to flush the response", ex);
        }
        try {
            this.getChannel().getResponse().closeOutput();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to complete the response", ex);
        }
    }

    public void flushBuffers() throws IOException {
        this.getChannel().getResponse().flushBuffer();
    }

    public List<Certificate> getCertificates() {
        Object certificateArray = this.getChannel().getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray instanceof Certificate[]) {
            return Arrays.asList((Certificate[])certificateArray);
        }
        return null;
    }

    public String getCipherSuite() {
        Object cipherSuite = this.getChannel().getRequest().getAttribute("javax.servlet.request.cipher_suite");
        if (cipherSuite instanceof String) {
            return (String)cipherSuite;
        }
        return null;
    }

    public String getClientAddress() {
        return this.getChannel().getRequest().getRemoteAddr();
    }

    public int getClientPort() {
        return this.getChannel().getRequest().getRemotePort();
    }

    public HttpChannel<?> getChannel() {
        return this.channel;
    }

    public String getMethod() {
        return this.getChannel().getRequest().getMethod();
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return this.getChannel().getRequest().getInputStream();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to get request entity stream", e);
            return null;
        }
    }

    public Series<Header> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            Enumeration names = this.getChannel().getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getChannel().getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    result.add(headerName, headerValue);
                }
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.getChannel().getRequest().getUri().toString();
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.getChannel().getResponse().getOutputStream();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to get response entity stream", e);
            return null;
        }
    }

    public String getServerAddress() {
        return this.getChannel().getRequest().getLocalAddr();
    }

    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getChannel().getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    public String getSslSessionId() {
        Object sessionId = this.getChannel().getRequest().getAttribute("javax.servlet.request.ssl_session_id");
        if (sessionId instanceof String) {
            return (String)sessionId;
        }
        return null;
    }

    public boolean isConfidential() {
        return this.getChannel().getRequest().isSecure();
    }

    public boolean isConnectionBroken(Throwable exception) {
        return exception instanceof EofException || super.isConnectionBroken(exception);
    }

    public void sendResponse(Response response) throws IOException {
        for (Header header : this.getResponseHeaders()) {
            this.getChannel().getResponse().addHeader(header.getName(), header.getValue());
        }
        if (Status.isError((int)this.getStatusCode()) && response.getEntity() == null) {
            try {
                this.getChannel().getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getChannel().getResponse().setStatus(this.getStatusCode());
            super.sendResponse(response);
        }
    }
}

