/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jibx;

import java.io.IOException;
import java.util.List;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.JiBXException;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jibx.JibxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class JibxConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (this.isCompatible(source)) {
            result = this.addObjectClass(result, JibxRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (this.isJibxBoundClass(source) || JibxRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    protected boolean isCompatible(MediaType mediaType) {
        return mediaType != null && (MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)mediaType) || MediaType.APPLICATION_XML.isCompatible((Metadata)mediaType) || MediaType.TEXT_XML.isCompatible((Metadata)mediaType));
    }

    protected boolean isCompatible(Variant variant) {
        return variant != null && (VARIANT_APPLICATION_ALL_XML.isCompatible(variant) || VARIANT_APPLICATION_XML.isCompatible(variant) || VARIANT_TEXT_XML.isCompatible(variant));
    }

    private boolean isJibxBoundClass(Class<?> source) {
        boolean result = false;
        try {
            if (source != null && BindingDirectory.getFactory(source) != null) {
                result = true;
            }
        }
        catch (JiBXException jiBXException) {
            // empty catch block
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source != null && (source instanceof JibxRepresentation || this.isJibxBoundClass(source.getClass()))) {
            result = target == null ? 0.5f : (this.isCompatible(target.getMediaType()) ? 1.0f : 0.5f);
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source != null) {
            if (source instanceof JibxRepresentation) {
                result = 1.0f;
            } else if (JibxRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (this.isJibxBoundClass(target) || JibxRepresentation.class.isAssignableFrom(source.getClass())) {
                result = 1.0f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        JibxRepresentation jibxSource = null;
        jibxSource = source instanceof JibxRepresentation ? (JibxRepresentation)source : new JibxRepresentation(source, target);
        T result = null;
        if (target == null) {
            try {
                result = jibxSource.getObject();
            }
            catch (JiBXException e) {
                throw new IOException("Cannot retrieve the wrapped object inside the JiBX representation due to " + e.getMessage());
            }
        }
        if (JibxRepresentation.class.isAssignableFrom(target)) {
            result = target.cast((Object)jibxSource);
        } else if (this.isJibxBoundClass(target)) {
            try {
                result = jibxSource.getObject();
            }
            catch (JiBXException e) {
                throw new IOException("Cannot convert the given representation to an object of this class using Jibx converter " + target + " due to " + e.getMessage());
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        Object result = null;
        if (this.isJibxBoundClass(source.getClass())) {
            result = new JibxRepresentation<Object>(target.getMediaType(), source);
        } else if (source instanceof JibxRepresentation) {
            result = (Representation)source;
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (this.isJibxBoundClass(entity) || JibxRepresentation.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
        }
    }
}

