/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.lucene.internal;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLResponseWriter;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.WriterRepresentation;

public class SolrRepresentation
extends WriterRepresentation {
    protected SolrQueryRequest solrQueryRequest;
    protected SolrQueryResponse solrQueryResponse;

    public SolrRepresentation(MediaType mediaType, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(mediaType);
        this.setCharacterSet(CharacterSet.UTF_8);
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    public SolrRepresentation(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this(null, solrQueryRequest, solrQueryResponse);
    }

    public void write(Writer writer) throws IOException {
        Object qrWriter = MediaType.APPLICATION_JSON.isCompatible((Metadata)this.getMediaType()) || MediaType.APPLICATION_JAVASCRIPT.isCompatible((Metadata)this.getMediaType()) ? new JSONResponseWriter() : new XMLResponseWriter();
        qrWriter.write(writer, this.solrQueryRequest, this.solrQueryResponse);
    }
}

