/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.lucene;

import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientHelper;
import org.restlet.ext.lucene.internal.SolrRepresentation;
import org.restlet.ext.lucene.internal.SolrRestletQueryRequest;
import org.restlet.representation.Representation;

public class SolrClientHelper
extends ClientHelper {
    public static Protocol SOLR_PROTOCOL = new Protocol("solr", "Solr", "Solr indexer helper", -1);
    protected CoreContainer coreContainer;

    public SolrClientHelper(Client client) {
        super(client);
        this.getProtocols().add(SOLR_PROTOCOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) {
        SolrCore core;
        String coreName;
        super.handle(request, response);
        Reference resRef = request.getResourceRef();
        String path = resRef.getPath();
        if (path != null) {
            path = resRef.getPath(true);
        }
        if ((coreName = request.getResourceRef().getHostDomain()) == null || "".equals(coreName)) {
            coreName = this.getContext().getParameters().getFirstValue("DefaultCore");
        }
        if ((core = this.coreContainer.getCore(coreName)) == null) {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, "No such core: " + coreName);
            return;
        }
        SolrRequestHandler handler = core.getRequestHandler(path);
        if (handler == null) {
            String qt;
            if (("/select".equals(path) || "/select/".equalsIgnoreCase(path)) && (handler = core.getRequestHandler(qt = request.getResourceRef().getQueryAsForm().getFirstValue("qt"))) == null) {
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "unknown handler: " + qt);
                return;
            }
            if (handler == null && this.coreContainer != null && path.equals(this.coreContainer.getAdminPath())) {
                handler = this.coreContainer.getMultiCoreHandler();
            }
        }
        if (handler == null) {
            core.close();
            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "unknown handler: " + path);
            return;
        }
        try {
            SolrRestletQueryRequest solrReq = new SolrRestletQueryRequest(request, core);
            SolrQueryResponse solrResp = new SolrQueryResponse();
            core.execute(handler, (SolrQueryRequest)solrReq, solrResp);
            if (solrResp.getException() != null) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)solrResp.getException());
            } else {
                response.setEntity((Representation)new SolrRepresentation(MediaType.APPLICATION_XML, (SolrQueryRequest)solrReq, solrResp));
                response.setStatus(Status.SUCCESS_OK);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to evaluate " + resRef.toString(), e);
            response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        finally {
            core.close();
        }
    }

    public void start() {
        try {
            this.coreContainer = (CoreContainer)((Client)this.getHelped()).getContext().getAttributes().get("CoreContainer");
            if (this.coreContainer == null) {
                String directory = ((Client)this.getHelped()).getContext().getParameters().getFirstValue("directory");
                String configFile = ((Client)this.getHelped()).getContext().getParameters().getFirstValue("configFile");
                if (directory != null && configFile != null) {
                    File config = new File(configFile);
                    if (!config.exists()) {
                        config = new File(new URI(configFile));
                    }
                    this.coreContainer = CoreContainer.createAndLoad((String)directory, (File)config);
                }
            }
            if (this.coreContainer == null) {
                throw new RuntimeException("Could not initialize core container");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize core container", e);
        }
    }

    public void stop() throws Exception {
        super.stop();
    }
}

