/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Application;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.ext.nio.BaseHelper;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.connection.ConnectionPool;
import org.restlet.ext.nio.internal.controller.ConnectionController;
import org.restlet.ext.nio.internal.way.InboundWay;
import org.restlet.ext.nio.internal.way.OutboundWay;
import org.restlet.routing.VirtualHost;

public abstract class ConnectionHelper<T extends Connector>
extends BaseHelper<T> {
    private volatile ConnectionPool<T> connectionPool = null;
    private final List<Connection<T>> connections = new CopyOnWriteArrayList<Connection<T>>();

    public ConnectionHelper(T connector, boolean clientSide) {
        super(connector, clientSide);
    }

    public void addOutboundMessage(Response response) {
        if (Application.getCurrent() != null) {
            response.getAttributes().put("org.restlet.application", Application.getCurrent());
        }
        if (Context.getCurrent() != null) {
            response.getAttributes().put("org.restlet.context", Context.getCurrent());
        }
        if (VirtualHost.getCurrent() != null) {
            response.getAttributes().put("org.restlet.virtualHost", VirtualHost.getCurrent());
        }
        this.getOutboundMessages().add(response);
        this.getController().wakeup();
    }

    public void checkin(Connection<?> connection) {
        connection.clear();
        if (this.isPooledConnection()) {
            this.getConnectionPool().checkin(connection);
        }
    }

    public Connection<T> checkout(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        Connection<T> result = null;
        if (this.isPooledConnection()) {
            result = (Connection<T>)this.getConnectionPool().checkout();
            result.reuse(socketChannel, controller, socketAddress);
        } else {
            result = this.createConnection(socketChannel, controller, socketAddress);
        }
        return result;
    }

    public void configure(Socket socket) throws SocketException {
        socket.setKeepAlive(this.isSocketKeepAlive());
        socket.setOOBInline(this.isSocketOobInline());
        socket.setReceiveBufferSize(this.getSocketReceiveBufferSize());
        socket.setReuseAddress(this.isSocketReuseAddress());
        socket.setSoLinger(this.getSocketLingerTimeMs() > 0, this.getSocketLingerTimeMs());
        socket.setSendBufferSize(this.getSocketSendBufferSize());
        socket.setSoTimeout(this.getMaxIoIdleTimeMs());
        socket.setTcpNoDelay(this.isSocketNoDelay());
        socket.setTrafficClass(this.getSocketTrafficClass());
    }

    public abstract Connection<T> createConnection(SocketChannel var1, ConnectionController var2, InetSocketAddress var3) throws IOException;

    public void createConnectionPool() {
        if (this.isPooledConnection()) {
            this.connectionPool = new ConnectionPool(this, this.getInitialConnections());
        }
    }

    public abstract InboundWay createInboundWay(Connection<T> var1, int var2);

    public abstract OutboundWay createOutboundWay(Connection<T> var1, int var2);

    @Override
    protected void doFinishStop() {
        super.doFinishStop();
        if (this.isPooledConnection()) {
            this.connectionPool = null;
        }
    }

    @Override
    protected void doGracefulStop() {
        super.doGracefulStop();
        for (Connection<T> connection : this.getConnections()) {
            connection.close(true);
        }
    }

    public ConnectionPool<T> getConnectionPool() {
        return this.connectionPool;
    }

    public List<Connection<T>> getConnections() {
        return this.connections;
    }

    public int getInitialConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("initialConnections", "100"));
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "-1"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "-1"));
    }

    public int getSocketLingerTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketLingerTimeMs", "-1"));
    }

    public int getSocketReceiveBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketReceiveBufferSize", "8192"));
    }

    public int getSocketSendBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketSendBufferSize", "8192"));
    }

    public int getSocketTrafficClass() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketTrafficClass", "0"));
    }

    public boolean isPersistingConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("persistingConnections", "true"));
    }

    public boolean isPipeliningConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("pipeliningConnections", "false"));
    }

    public boolean isPooledConnection() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("pooledConnections", "true"));
    }

    public abstract boolean isProxying();

    public boolean isSocketKeepAlive() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketKeepAlive", "true"));
    }

    public boolean isSocketNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketNoDelay", "false"));
    }

    public boolean isSocketOobInline() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketOobInline", "false"));
    }

    public boolean isSocketReuseAddress() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketReuseAddress", "true"));
    }
}

