/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Response;
import org.restlet.data.Header;
import org.restlet.data.Status;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.nio.internal.buffer.Buffer;
import org.restlet.ext.nio.internal.buffer.BufferState;
import org.restlet.ext.nio.internal.channel.ReadableBufferedChannel;
import org.restlet.ext.nio.internal.channel.ReadableChunkedChannel;
import org.restlet.ext.nio.internal.channel.ReadableSizedSelectionChannel;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.state.MessageState;
import org.restlet.ext.nio.internal.way.Way;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.ReadableRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

public abstract class InboundWay
extends Way {
    private volatile int builderIndex = 0;
    private volatile SelectionRegistration entityRegistration;

    public InboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.builderIndex = 0;
        this.entityRegistration = null;
    }

    protected Representation createEntity(Series<Header> headers) {
        EmptyRepresentation result = null;
        long contentLength = HeaderUtils.getContentLength(headers);
        boolean chunkedEncoding = HeaderUtils.isChunkedEncoding(headers);
        boolean connectionClose = HeaderUtils.isConnectionClose(headers);
        if (contentLength != -1L && contentLength != 0L || chunkedEncoding || connectionClose) {
            ReadableBufferedChannel inboundEntityChannel = null;
            inboundEntityChannel = chunkedEncoding ? new ReadableChunkedChannel(this, this.getBuffer(), this.getConnection().getReadableSelectionChannel(), this.getConnection().getRegistration().getWakeupListener()) : new ReadableSizedSelectionChannel(this, this.getBuffer(), this.getConnection().getReadableSelectionChannel(), contentLength, this.getRegistration().getWakeupListener());
            this.setEntityRegistration(inboundEntityChannel.getRegistration());
            if (inboundEntityChannel != null) {
                result = new ReadableRepresentation((ReadableByteChannel)((Object)inboundEntityChannel), null, contentLength);
                result.setSize(contentLength);
                this.setMessageState(MessageState.BODY);
            }
        } else {
            result = new EmptyRepresentation();
        }
        if (headers != null) {
            try {
                result = HeaderUtils.extractEntityHeaders(headers, (Representation)result);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Error while parsing entity headers", t);
            }
        }
        return result;
    }

    protected boolean fillLine() throws IOException {
        boolean result = false;
        this.setLineBuilderState(this.getBuffer().drain(this.getLineBuilder(), this.getLineBuilderState()));
        if (this.getLineBuilderState() == BufferState.DRAINING) {
            result = true;
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, this.getLineBuilder().toString());
            }
        }
        return result;
    }

    protected int getBuilderIndex() {
        return this.builderIndex;
    }

    protected SelectionRegistration getEntityRegistration() {
        return this.entityRegistration;
    }

    @Override
    public int getInterestOperations() {
        int result = 0;
        if (this.getIoState() == IoState.INTEREST) {
            result = 1;
        }
        return result;
    }

    protected boolean isLineReadable() throws IOException {
        return this.getBuffer().canDrain() && this.getMessageState() != MessageState.IDLE && this.getMessageState() != MessageState.BODY && this.fillLine();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        super.onMessageCompleted(endDetected);
        this.getHelper().getController().wakeup();
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Inbound message completed");
        }
    }

    @Override
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        int result = 0;
        boolean continueReading = true;
        int beforeDrain = buffer.remaining();
        while (continueReading && this.isLineReadable()) {
            if (this.getMessageState() == MessageState.START) {
                if (this.getLineBuilder().length() == 0) {
                    continueReading = false;
                    continue;
                }
                if (this.getHelper().getLogger().isLoggable(Level.FINE)) {
                    this.getHelper().getLogger().fine("Reading message from " + this.getConnection().getSocketAddress());
                }
                this.readStartLine();
                continue;
            }
            if (this.getMessageState() != MessageState.HEADERS) continue;
            Header header = this.readHeader();
            if (header != null) {
                if (this.getHeaders() == null) {
                    this.setHeaders((Series<Header>)new Series(Header.class));
                }
                this.getHeaders().add((Object)header);
                continue;
            }
            this.onHeadersCompleted();
        }
        result = beforeDrain - buffer.remaining();
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, result + " bytes read");
        }
        return result;
    }

    @Override
    public void onError(Status status) {
        this.getHelper().onInboundError(status, this.getMessage());
        this.setMessage(null);
    }

    @Override
    public int onFill(Buffer buffer, Object ... args) throws IOException {
        int result = this.getBuffer().fill((ReadableByteChannel)this.getConnection().getReadableSelectionChannel());
        if (result == -1) {
            this.getConnection().close(true);
        }
        return result;
    }

    @Override
    public void onFillEof() {
    }

    @Override
    protected void onPostProcessing() {
        this.setIoState(IoState.INTEREST);
    }

    @Override
    protected void onHeadersCompleted() throws IOException {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Inbound message start line and headers received");
        }
    }

    protected abstract void onReceived(Response var1) throws IOException;

    @Override
    public void onTimeOut() {
        if (this.getMessage() != null) {
            this.getHelper().onInboundError(Status.CONNECTOR_ERROR_COMMUNICATION, this.getMessage());
        }
    }

    @Override
    public int processIoBuffer() throws IOException {
        int result = 0;
        if (this.getMessageState() == MessageState.BODY && this.getEntityRegistration() != null) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Entity registration selected : " + this.getRegistration().getClass());
            }
            if (this.getIoState() == IoState.READY) {
                if (this.getEntityRegistration().getSelectionListener() != null) {
                    this.getEntityRegistration().getSelectionListener().onSelected(this.getEntityRegistration());
                }
            } else {
                this.getEntityRegistration().onSelected(this.getRegistration().getReadyOperations());
            }
        } else {
            result = super.processIoBuffer();
        }
        return result;
    }

    protected Header readHeader() throws IOException {
        Header header = HeaderReader.readHeader((CharSequence)this.getLineBuilder());
        this.clearLineBuilder();
        return header;
    }

    protected abstract void readStartLine() throws IOException;

    protected void setBuilderIndex(int builderIndex) {
        this.builderIndex = builderIndex;
    }

    protected void setEntityRegistration(SelectionRegistration entityRegistration) {
        this.entityRegistration = entityRegistration;
    }

    @Override
    public void updateState() {
        if (this.getMessageState() == MessageState.BODY) {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "Old inbound way NIO interest: " + this.getRegistration());
                this.getHelper().getLogger().log(Level.FINEST, "Old inbound entity NIO interest: " + this.getEntityRegistration());
            }
            if (this.getEntityRegistration() != null && this.getEntityRegistration().getSelectionListener() != null) {
                this.getRegistration().setInterestOperations(this.getEntityRegistration().getInterestOperations());
            } else {
                this.getRegistration().setInterestOperations(0);
            }
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "New inbound entity NIO interest: " + this.getEntityRegistration());
                this.getHelper().getLogger().log(Level.FINEST, "New inbound way NIO interest: " + this.getRegistration());
            }
        } else {
            super.updateState();
        }
    }
}

