/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.restlet.ext.nio.internal.channel.TraceChannel;
import org.restlet.ext.nio.internal.channel.WritableSelectionChannel;

public class WritableTraceChannel
extends TraceChannel<WritableSelectionChannel>
implements WritableSelectionChannel {
    public WritableTraceChannel(WritableSelectionChannel wrappedChannel) {
        super(wrappedChannel);
    }

    public WritableTraceChannel(WritableSelectionChannel wrappedChannel, OutputStream traceStream) {
        super(wrappedChannel, traceStream);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int oldPos = src.position();
        int off = src.arrayOffset() + oldPos;
        int result = ((WritableSelectionChannel)this.getWrappedChannel()).write(src);
        int newPos = src.position();
        if (result > 0 && newPos > oldPos) {
            System.out.write(src.array(), off, newPos - oldPos);
        }
        return result;
    }
}

