/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.restlet.engine.util.Base64;
import org.restlet.ext.crypto.DigestUtils;

public final class CryptoUtils {
    private static Cipher createCipher(String algorithm, byte[] secretKey, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(mode, new SecretKeySpec(secretKey, algorithm));
        return cipher;
    }

    public static String decrypt(String algo, byte[] secretKey, byte[] encrypted) throws GeneralSecurityException {
        byte[] original = CryptoUtils.doFinal(algo, secretKey, 2, encrypted);
        return new String(original);
    }

    public static String decrypt(String algo, String base64Secret, byte[] encrypted) throws GeneralSecurityException {
        return CryptoUtils.decrypt(algo, Base64.decode((String)base64Secret), encrypted);
    }

    private static byte[] doFinal(String algo, byte[] secretKey, int mode, byte[] what) throws GeneralSecurityException {
        return CryptoUtils.createCipher(algo, secretKey, mode).doFinal(what);
    }

    public static byte[] encrypt(String algo, byte[] secretKey, String content) throws GeneralSecurityException {
        return CryptoUtils.doFinal(algo, secretKey, 1, content.getBytes());
    }

    public static byte[] encrypt(String algo, String base64Secret, String content) throws GeneralSecurityException {
        return CryptoUtils.encrypt(algo, Base64.decode((String)base64Secret), content);
    }

    public static String makeNonce(String secretKey) {
        long currentTimeMS = System.currentTimeMillis();
        return Base64.encode((byte[])(currentTimeMS + ":" + DigestUtils.toMd5((String)(currentTimeMS + ":" + secretKey))).getBytes(), (boolean)true);
    }

    private CryptoUtils() {
    }
}

