/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.ext.oauth.AuthorizationBaseServerResource;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.RedirectionURI;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.ServerToken;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.routing.Redirector;
import org.restlet.security.User;

public class AuthorizationServerResource
extends AuthorizationBaseServerResource {
    public static final String PARAMETER_SUPPORT_POST = "supportPost";

    protected Representation doPostAuthorization(AuthSession session, Client client) {
        String[] scopes;
        Reference ref = new Reference("riap://application" + HttpOAuthHelper.getAuthPage(this.getContext()));
        this.getLogger().fine("Name = " + this.getApplication().getInboundRoot());
        ref.addQueryParameter("client", session.getClientId());
        for (String s : scopes = session.getRequestedScope()) {
            ref.addQueryParameter("scope", s);
        }
        ServerToken token = (ServerToken)this.tokens.findToken(client, session.getScopeOwner());
        if (token != null && !token.isExpired()) {
            for (String s : token.getScope()) {
                ref.addQueryParameter("grantedScope", s);
            }
        }
        this.getLogger().fine("Redir = " + ref);
        Redirector dispatcher = new Redirector(this.getContext(), ref.toString(), 6);
        dispatcher.handle(this.getRequest(), this.getResponse());
        return this.getResponseEntity();
    }

    protected RedirectionURI getRedirectionURI(Form params, Client client) throws OAuthException {
        String redirectURI = params.getFirstValue("redirect_uri");
        String[] redirectURIs = client.getRedirectURIs();
        if (redirectURIs == null || redirectURIs.length != 1) {
            if (redirectURI == null || redirectURI.isEmpty()) {
                throw new OAuthException(OAuthError.invalid_request, "Client MUST include a redirection URI.", null);
            }
        } else if (redirectURI == null || redirectURI.isEmpty()) {
            return new RedirectionURI(redirectURIs[0]);
        }
        for (String uri : redirectURIs) {
            if (!redirectURI.startsWith(uri)) continue;
            return new RedirectionURI(redirectURI, true);
        }
        throw new OAuthException(OAuthError.invalid_request, "Callback URI does not match.", null);
    }

    protected ResponseType[] getResponseType(Form params) throws OAuthException {
        String responseType = params.getFirstValue("response_type");
        if (responseType == null || responseType.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "No response_type parameter found.", null);
        }
        String[] typesString = Scopes.parseScope(responseType);
        ResponseType[] types = new ResponseType[typesString.length];
        for (int i = 0; i < typesString.length; ++i) {
            try {
                ResponseType type = Enum.valueOf(ResponseType.class, typesString[i]);
                this.getLogger().fine("Found flow - " + (Object)((Object)type));
                types[i] = type;
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new OAuthException(OAuthError.unsupported_response_type, "Unsupported flow", null);
            }
        }
        return types;
    }

    @Get(value="html")
    public Representation requestAuthorization() throws OAuthException {
        return this.requestAuthorization(this.getQuery());
    }

    public Representation requestAuthorization(Form params) throws OAuthException {
        RedirectionURI redirectURI;
        Client client;
        AuthSession session = this.getAuthSession();
        if (session != null) {
            return this.doPostAuthorization(session, this.clients.findById(session.getClientId()));
        }
        try {
            client = this.getClient(params);
            redirectURI = this.getRedirectionURI(params, client);
        }
        catch (OAuthException ex) {
            return this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), ex);
        }
        catch (Exception ex) {
            OAuthException oex = new OAuthException(OAuthError.server_error, ex.getMessage(), null);
            return this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), oex);
        }
        session = this.setupAuthSession(redirectURI);
        try {
            ResponseType[] responseTypes = this.getResponseType(params);
            if (responseTypes.length != 1) {
                throw new OAuthException(OAuthError.unsupported_response_type, "Extension response types are not supported.", null);
            }
            if (!client.isResponseTypeAllowed(responseTypes[0])) {
                throw new OAuthException(OAuthError.unauthorized_client, "Unauthorized response type.", null);
            }
            session.setAuthFlow(responseTypes[0]);
            session.setClientId(client.getClientId());
            String[] scope = this.getScope(params);
            session.setRequestedScope(scope);
            String state = this.getState(params);
            if (state != null && !state.isEmpty()) {
                session.setState(state);
            }
        }
        catch (OAuthException ex) {
            this.ungetAuthSession();
            throw ex;
        }
        User scopeOwner = this.getRequest().getClientInfo().getUser();
        if (scopeOwner != null) {
            session.setScopeOwner(scopeOwner.getIdentifier());
        }
        if (session.getScopeOwner() == null) {
            Reference ref = new Reference("." + HttpOAuthHelper.getLoginPage(this.getContext()));
            ref.addQueryParameter("continue", this.getRequest().getOriginalRef().toString(true, false));
            this.redirectTemporary(ref.toString());
            return new EmptyRepresentation();
        }
        return this.doPostAuthorization(session, client);
    }

    @Post(value="html")
    public Representation requestAuthorization(Representation input) throws OAuthException {
        Object supportPost = this.getContext().getAttributes().get(PARAMETER_SUPPORT_POST);
        if (!Boolean.parseBoolean(supportPost.toString())) {
            throw new OAuthException(OAuthError.invalid_request, "Authorization endpoint does NOT support the use of the POST method.", null);
        }
        return this.requestAuthorization(new Form(input));
    }
}

