/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSessionTimeoutException;
import org.restlet.ext.oauth.internal.RedirectionURI;

public class AuthSession {
    private static final String CALLBACK = "callback";
    private static final String CLIENT_ID = "client_id";
    public static final int DEFAULT_TIMEOUT_SEC = 600;
    private static final String FLOW = "flow";
    private static final String GRANTED_SCOPE = "granted_scope";
    private static final String ID = "id";
    private static final String LAST_ACTIVITY = "last_activity";
    private static final String OWNER = "owner";
    private static final String REQ_SCOPE = "requested_scope";
    private static final String STATE = "state";
    private static final String TIMEOUT_SEC = "timeout_sec";
    private final ConcurrentMap<String, Object> attribs = new ConcurrentHashMap<String, Object>();

    public static AuthSession newAuthSession() {
        AuthSession session = new AuthSession();
        String sessionId = UUID.randomUUID().toString();
        session.setAttribute(ID, sessionId);
        session.setAttribute(LAST_ACTIVITY, System.currentTimeMillis());
        session.setSessionTimeout(600);
        return session;
    }

    public static AuthSession toAuthSession(Map<String, Object> attribs) {
        AuthSession session = new AuthSession();
        for (String key : attribs.keySet()) {
            session.attribs.put(key.toString(), attribs.get(key));
        }
        return session;
    }

    private AuthSession() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthSession)) {
            return false;
        }
        AuthSession e = (AuthSession)obj;
        return this.attribs.equals(e.attribs);
    }

    private Object getAttribute(String name) {
        return this.attribs.get(name);
    }

    public ResponseType getAuthFlow() {
        String name = (String)this.getAttribute(FLOW);
        if (name == null) {
            return null;
        }
        return ResponseType.valueOf(name);
    }

    public String getClientId() {
        return (String)this.getAttribute(CLIENT_ID);
    }

    public String[] getGrantedScope() {
        List list = (List)this.getAttribute(GRANTED_SCOPE);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getId() {
        return (String)this.getAttribute(ID);
    }

    public RedirectionURI getRedirectionURI() {
        Map map = (Map)this.getAttribute(CALLBACK);
        if (map == null) {
            return null;
        }
        String uri = map.get("uri").toString();
        Boolean dynamic = (Boolean)map.get("dynamic");
        return new RedirectionURI(uri, dynamic);
    }

    public String[] getRequestedScope() {
        List list = (List)this.getAttribute(REQ_SCOPE);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getScopeOwner() {
        return (String)this.getAttribute(OWNER);
    }

    public int getSessionTimeout() {
        return ((Number)this.getAttribute(TIMEOUT_SEC)).intValue();
    }

    public String getState() {
        return (String)this.getAttribute(STATE);
    }

    private Object removeAttribute(String name) {
        return this.attribs.remove(name);
    }

    private void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attribs.put(name, value);
        }
    }

    public void setAuthFlow(ResponseType flow) {
        this.setAttribute(FLOW, flow.name());
    }

    public void setClientId(String clientId) {
        this.setAttribute(CLIENT_ID, clientId);
    }

    public void setGrantedScope(String[] scope) {
        this.setAttribute(GRANTED_SCOPE, Arrays.asList(scope));
    }

    public void setRedirectionURI(RedirectionURI uri) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uri", uri.getURI());
        map.put("dynamic", uri.isDynamicConfigured());
        this.setAttribute(CALLBACK, map);
    }

    public void setRequestedScope(String[] scope) {
        this.setAttribute(REQ_SCOPE, Arrays.asList(scope));
    }

    public void setScopeOwner(String owner) {
        this.setAttribute(OWNER, owner);
    }

    public void setSessionTimeout(int timeSeconds) {
        this.setAttribute(TIMEOUT_SEC, timeSeconds);
    }

    public void setState(String state) {
        this.setAttribute(STATE, state);
    }

    public Map<String, Object> toMap() {
        return this.attribs;
    }

    public void updateActivity() throws AuthSessionTimeoutException {
        long lastActivity;
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - (lastActivity = ((Number)this.getAttribute(LAST_ACTIVITY)).longValue());
        if (delta / 1000L >= (long)this.getSessionTimeout()) {
            throw new AuthSessionTimeoutException();
        }
        lastActivity = System.currentTimeMillis();
        this.setAttribute(LAST_ACTIVITY, lastActivity);
    }
}

