/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.Arrays;
import java.util.Map;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Client;

public class MemoryClient
implements Client {
    private String clientId;
    private char[] clientSecret;
    private Client.ClientType clientType;
    private Map<String, Object> properties;
    private String[] redirectURIs;

    protected MemoryClient(String clientId, Client.ClientType clientType, String[] redirectURIs, Map<String, Object> properties) {
        this.clientId = clientId;
        this.clientType = clientType;
        this.redirectURIs = redirectURIs;
        this.properties = properties;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public char[] getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public Client.ClientType getClientType() {
        return this.clientType;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String[] getRedirectURIs() {
        return this.redirectURIs;
    }

    private boolean isFlowSupported(Object flow) {
        return Arrays.asList((Object[])this.properties.get("supported_flows")).contains(flow);
    }

    @Override
    public boolean isGrantTypeAllowed(GrantType grantType) {
        return this.isFlowSupported((Object)grantType);
    }

    @Override
    public boolean isResponseTypeAllowed(ResponseType responseType) {
        return this.isFlowSupported((Object)responseType);
    }

    protected void setClientSecret(char[] clientSecret) {
        this.clientSecret = clientSecret;
    }
}

