/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import javax.naming.AuthenticationException;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.AuthSessionTimeoutException;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.ResourceOwnerManager;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.security.User;

public class AccessTokenServerResource
extends OAuthServerResource {
    private Representation doAuthCodeFlow(Form params) throws OAuthException, JSONException {
        String redirectURI;
        Client client = this.getAuthenticatedClient();
        if (client == null) {
            client = this.getClient(params);
        }
        this.ensureGrantTypeAllowed(client, GrantType.authorization_code);
        String code = this.getCode(params);
        AuthSession session = this.tokens.restoreSession(code);
        if (!client.getClientId().equals(session.getClientId())) {
            throw new OAuthException(OAuthError.invalid_grant, "The code was not issued to the client.", null);
        }
        try {
            session.updateActivity();
        }
        catch (AuthSessionTimeoutException ex) {
            throw new OAuthException(OAuthError.invalid_grant, "Code expired.", null);
        }
        if (session.getRedirectionURI().isDynamicConfigured() && !(redirectURI = this.getRedirectURI(params)).equals(session.getRedirectionURI().getURI())) {
            throw new OAuthException(OAuthError.invalid_grant, "The redirect_uri is not identical to the one included in the initial authorization request.", null);
        }
        Token token = this.tokens.generateToken(client, session.getScopeOwner(), session.getGrantedScope());
        return this.responseTokenRepresentation(token, session.getRequestedScope());
    }

    protected void doCatch(Throwable t) {
        t.printStackTrace();
        OAuthException oex = OAuthException.toOAuthException(t);
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        this.getResponse().setEntity(AccessTokenServerResource.responseErrorRepresentation(oex));
        AccessTokenServerResource.addCacheDirective(this.getResponse(), CacheDirective.noStore());
    }

    private Representation doClientFlow(Form params) throws OAuthException, JSONException {
        Client client = this.getAuthenticatedClient();
        if (client == null || client.getClientType() != Client.ClientType.CONFIDENTIAL) {
            throw new OAuthException(OAuthError.invalid_client, "The client credentials grant type MUST only be used by confidential clients.", null);
        }
        this.ensureGrantTypeAllowed(client, GrantType.client_credentials);
        String[] requestedScope = this.getScope(params);
        Token token = this.tokens.generateToken(client, requestedScope);
        return this.responseTokenRepresentation(token, requestedScope);
    }

    private Representation doPasswordFlow(Form params) throws OAuthException, JSONException {
        String identifier;
        Object users = this.getContext().getAttributes().get(ResourceOwnerManager.class.getName());
        if (users == null) {
            throw new OAuthException(OAuthError.unsupported_grant_type, "'password' flow is not supported.", null);
        }
        Client client = this.getAuthenticatedClient();
        if (client == null) {
            client = this.getClient(params);
        }
        this.ensureGrantTypeAllowed(client, GrantType.password);
        String username = this.getUsername(params);
        String password = this.getPassword(params);
        try {
            identifier = ((ResourceOwnerManager)users).authenticate(username, password.toCharArray());
        }
        catch (AuthenticationException ex) {
            throw new OAuthException(OAuthError.invalid_grant, ex.getExplanation(), null);
        }
        String[] requestedScope = this.getScope(params);
        Token token = this.tokens.generateToken(client, identifier, requestedScope);
        return this.responseTokenRepresentation(token, requestedScope);
    }

    private Representation doRefreshFlow(Form params) throws OAuthException, JSONException {
        Client client = this.getAuthenticatedClient();
        if (client == null) {
            client = this.getClient(params);
        }
        this.ensureGrantTypeAllowed(client, GrantType.refresh_token);
        String refreshToken = this.getRefreshToken(params);
        String[] requestedScope = null;
        String scope = params.getFirstValue("scope");
        if (scope != null && !scope.isEmpty()) {
            requestedScope = Scopes.parseScope(scope);
        }
        Token token = this.tokens.refreshToken(client, refreshToken, requestedScope);
        return this.responseTokenRepresentation(token, requestedScope);
    }

    protected void ensureGrantTypeAllowed(Client client, GrantType grantType) throws OAuthException {
        if (!client.isGrantTypeAllowed(grantType)) {
            throw new OAuthException(OAuthError.unauthorized_client, "Unauthorized grant type.", null);
        }
    }

    protected Client getAuthenticatedClient() throws OAuthException {
        User authenticatedClient = this.getRequest().getClientInfo().getUser();
        if (authenticatedClient == null) {
            this.getLogger().warning("Authenticated client_id is missing.");
            return null;
        }
        Client client = this.clients.findById(authenticatedClient.getIdentifier());
        this.getLogger().fine("Requested by authenticated client " + client.getClientId());
        return client;
    }

    @Override
    protected Client getClient(Form params) throws OAuthException {
        Client client = super.getClient(params);
        if (client.getClientType() == Client.ClientType.CONFIDENTIAL) {
            throw new OAuthException(OAuthError.invalid_client, "Unauthenticated confidential client.", null);
        }
        if (client.getClientSecret() != null) {
            throw new OAuthException(OAuthError.invalid_client, "Unauthenticated public client.", null);
        }
        return client;
    }

    protected String getCode(Form params) throws OAuthException {
        String code = params.getFirstValue("code");
        if (code == null || code.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter code is missing", null);
        }
        return code;
    }

    protected GrantType getGrantType(Form params) throws OAuthException {
        String typeString = params.getFirstValue("grant_type");
        this.getLogger().info("Type: " + typeString);
        try {
            GrantType type = Enum.valueOf(GrantType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            return type;
        }
        catch (IllegalArgumentException iae) {
            throw new OAuthException(OAuthError.unsupported_grant_type, "Unsupported flow", null);
        }
        catch (NullPointerException npe) {
            throw new OAuthException(OAuthError.invalid_request, "No grant_type parameter found.", null);
        }
    }

    protected String getPassword(Form params) throws OAuthException {
        String password = params.getFirstValue("password");
        if (password == null || password.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter password is missing", null);
        }
        return password;
    }

    protected String getRedirectURI(Form params) throws OAuthException {
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter redirect_uri is missing", null);
        }
        return redirUri;
    }

    protected String getRefreshToken(Form params) throws OAuthException {
        String token = params.getFirstValue("refresh_token");
        if (token == null || token.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter refresh_token is missing", null);
        }
        return token;
    }

    protected String getUsername(Form params) throws OAuthException {
        String username = params.getFirstValue("username");
        if (username == null || username.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter username is missing", null);
        }
        return username;
    }

    @Post(value="form:json")
    public Representation requestToken(Representation input) throws OAuthException, JSONException {
        this.getLogger().fine("Grant request");
        Form params = new Form(input);
        GrantType grantType = this.getGrantType(params);
        switch (grantType) {
            case authorization_code: {
                this.getLogger().info("Authorization Code Grant");
                return this.doAuthCodeFlow(params);
            }
            case password: {
                this.getLogger().info("Resource Owner Password Credentials Grant");
                return this.doPasswordFlow(params);
            }
            case client_credentials: {
                this.getLogger().info("Client Credentials Grantt");
                return this.doClientFlow(params);
            }
            case refresh_token: {
                this.getLogger().info("Refreshing an Access Token");
                return this.doRefreshFlow(params);
            }
        }
        this.getLogger().warning("Unsupported flow: " + (Object)((Object)grantType));
        throw new OAuthException(OAuthError.unsupported_grant_type, "Flow not supported", null);
    }

    protected Representation responseTokenRepresentation(Token token, String[] requestedScope) throws JSONException {
        String[] scope;
        JSONObject response = new JSONObject();
        response.put("token_type", (Object)token.getTokenType());
        response.put("access_token", (Object)token.getAccessToken());
        response.put("expires_in", token.getExpirePeriod());
        String refreshToken = token.getRefreshToken();
        if (refreshToken != null && !refreshToken.isEmpty()) {
            response.put("refresh_token", (Object)refreshToken);
        }
        if (!Scopes.isIdentical(scope = token.getScope(), requestedScope)) {
            response.put("scope", (Object)Scopes.toString(scope));
        }
        AccessTokenServerResource.addCacheDirective(this.getResponse(), CacheDirective.noStore());
        return new JsonRepresentation(response);
    }
}

