/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.data.CookieSetting;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.freemarker.ContextTemplateLoader;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.AuthSessionTimeoutException;
import org.restlet.ext.oauth.internal.RedirectionURI;
import org.restlet.representation.Representation;

public class AuthorizationBaseServerResource
extends OAuthServerResource {
    private static final String ClientCookieID = "_cid";

    protected void doCatch(Throwable t) {
        OAuthException oex = OAuthException.toOAuthException(t);
        AuthSession session = null;
        try {
            session = this.getAuthSession();
        }
        catch (OAuthException ignore) {
            // empty catch block
        }
        if (session == null || session.getAuthFlow() == null) {
            Representation resp = this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), oex);
            this.getResponse().setEntity(resp);
        } else {
            boolean fragment = session.getAuthFlow().equals((Object)ResponseType.token);
            this.sendError(session.getRedirectionURI().getURI(), oex, session.getState(), fragment);
        }
    }

    protected AuthSession getAuthSession() throws OAuthException {
        AuthSession session;
        String sessionId = this.getCookies().getFirstValue(ClientCookieID);
        this.getLogger().fine("sessionId = " + sessionId);
        AuthSession authSession = session = sessionId == null ? null : (AuthSession)this.getContext().getAttributes().get(sessionId);
        if (session == null) {
            return null;
        }
        try {
            session.updateActivity();
        }
        catch (AuthSessionTimeoutException ex) {
            this.getContext().getAttributes().remove(sessionId);
            throw new OAuthException(OAuthError.server_error, "Session timeout", null);
        }
        return session;
    }

    protected Representation getErrorPage(String errPage, OAuthException ex) {
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)new ContextTemplateLoader(this.getContext(), "clap:///"));
        this.getLogger().fine("loading: " + errPage);
        TemplateRepresentation response = new TemplateRepresentation(errPage, config, MediaType.TEXT_HTML);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("error", ex.getError().name());
        data.put("error_description", ex.getErrorDescription());
        data.put("error_uri", ex.getErrorURI());
        response.setDataModel(data);
        return response;
    }

    protected void sendError(String redirectURI, OAuthException ex, String state, boolean fragment) {
        String errorUri;
        String description;
        Reference cb = new Reference(redirectURI);
        cb.addQueryParameter("error", ex.getError().name());
        if (state != null && state.length() > 0) {
            cb.addQueryParameter("state", state);
        }
        if ((description = ex.getErrorDescription()) != null && description.length() > 0) {
            cb.addQueryParameter("error_description", description);
        }
        if ((errorUri = ex.getErrorURI()) != null && errorUri.length() > 0) {
            cb.addQueryParameter("error_uri", errorUri);
        }
        if (fragment) {
            cb.setFragment(cb.getQuery());
            cb.setQuery("");
        }
        this.redirectTemporary(cb);
    }

    protected AuthSession setupAuthSession(RedirectionURI redirectUri) {
        this.getLogger().fine("Base ref = " + this.getReference().getParentRef());
        AuthSession session = AuthSession.newAuthSession();
        session.setRedirectionURI(redirectUri);
        CookieSetting cs = new CookieSetting(ClientCookieID, session.getId());
        this.getCookieSettings().add((Object)cs);
        this.getLogger().fine("Setting cookie in SetupSession - " + session.getId());
        this.getContext().getAttributes().put(session.getId(), session);
        return session;
    }

    protected void ungetAuthSession() {
        String sessionId = this.getCookies().getFirstValue(ClientCookieID);
        if (sessionId != null && sessionId.length() > 0) {
            ConcurrentMap attribs = this.getContext().getAttributes();
            attribs.remove(sessionId);
        }
    }
}

