/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.json.JSONException;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.Base64;
import org.restlet.ext.oauth.AccessTokenClientResource;
import org.restlet.ext.oauth.FacebookAccessTokenClientResource;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.Filter;

public class OAuthProxy
extends Filter
implements OAuthResourceDefs {
    private static final List<CacheDirective> no = new ArrayList<CacheDirective>();
    private static final String VERSION = "RFC6749";
    private String authorizationURI;
    private final boolean basicSecret;
    private final Client cc;
    private String clientId;
    private String clientSecret;
    private final SecureRandom random;
    private String redirectURI;
    private String[] scope;
    private String tokenURI;

    public static String getVersion() {
        return VERSION;
    }

    public OAuthProxy(Context ctx) {
        this(ctx, true);
    }

    public OAuthProxy(Context ctx, boolean useBasicSecret) {
        this(ctx, useBasicSecret, null);
    }

    public OAuthProxy(Context ctx, boolean useBasicSecret, Client requestClient) {
        this.basicSecret = useBasicSecret;
        this.setContext(ctx);
        no.add(CacheDirective.noStore());
        this.cc = requestClient;
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected int beforeHandle(Request request, Response response) {
        request.setCacheDirectives(no);
        Form params = new Form(request.getOriginalRef().getQuery());
        this.getLogger().fine("Incomming request query = " + params);
        try {
            String error = params.getFirstValue("error");
            if (error != null && !error.isEmpty()) {
                this.validateState(request, params);
                return this.sendErrorPage(response, OAuthException.toOAuthException(params));
            }
            String code = params.getFirstValue("code");
            if (code != null && !code.isEmpty()) {
                this.validateState(request, params);
                Token token = this.requestToken(code);
                request.getAttributes().put(Token.class.getName(), token);
                return 0;
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof OAuthException)) {
                this.getLogger().log(Level.SEVERE, "OAuthProxy error", ex);
            }
            return this.sendErrorPage(response, ex);
        }
        OAuthParameters authRequest = this.createAuthorizationRequest();
        authRequest.state(this.setupState(response));
        Reference redirRef = authRequest.toReference(this.getAuthorizationURI());
        this.getLogger().fine("Redirecting to : " + redirRef.toUri());
        response.setCacheDirectives(no);
        response.redirectTemporary(redirRef);
        this.getLogger().fine("After Redirecting to : " + redirRef.toUri());
        return 2;
    }

    protected OAuthParameters createAuthorizationRequest() {
        OAuthParameters parameters = new OAuthParameters().responseType(ResponseType.code).add("client_id", this.getClientId());
        if (this.redirectURI != null) {
            parameters.redirectURI(this.redirectURI);
        }
        if (this.scope != null) {
            parameters.scope(this.scope);
        }
        return parameters;
    }

    protected OAuthParameters createTokenRequest(String code) {
        OAuthParameters parameters = new OAuthParameters().grantType(GrantType.authorization_code).code(code);
        if (this.redirectURI != null) {
            parameters.redirectURI(this.redirectURI);
        }
        return parameters;
    }

    public String getAuthorizationURI() {
        return this.authorizationURI;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    protected Representation getErrorPage(Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><pre>");
        if (ex instanceof OAuthException) {
            OAuthException oex = (OAuthException)ex;
            sb.append("OAuth2 error detected.\n");
            sb.append("Error : ").append((Object)oex.getError());
            if (oex.getErrorDescription() != null) {
                sb.append("Error description : ").append(oex.getErrorDescription());
            }
            if (oex.getErrorURI() != null) {
                sb.append("<a href=\"");
                sb.append(oex.getErrorURI());
                sb.append("\">Error Description</a>");
            }
        } else {
            sb.append("General error detected.\n");
            sb.append("Error : ").append(ex.getMessage());
        }
        sb.append("</pre></body></html>");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public String[] getScope() {
        return this.scope;
    }

    public String getTokenURI() {
        return this.tokenURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token requestToken(String code) throws OAuthException, IOException, JSONException {
        AccessTokenClientResource tokenResource;
        this.getLogger().fine("Came back after authorization code = " + code);
        String endpoint = this.getTokenURI();
        if (endpoint.contains("graph.facebook.com")) {
            tokenResource = new FacebookAccessTokenClientResource(new Reference(endpoint));
        } else {
            tokenResource = new AccessTokenClientResource(new Reference(endpoint));
            tokenResource.setAuthenticationMethod((ChallengeScheme)(this.basicSecret ? ChallengeScheme.HTTP_BASIC : null));
        }
        tokenResource.setClientCredentials(this.getClientId(), this.getClientSecret());
        if (this.cc != null) {
            tokenResource.setNext((Uniform)this.cc);
        }
        OAuthParameters tokenRequest = this.createTokenRequest(code);
        try {
            this.getLogger().fine("Sending access form : " + tokenRequest);
            Token token = tokenResource.requestToken(tokenRequest);
            return token;
        }
        finally {
            tokenResource.release();
        }
    }

    private int sendErrorPage(Response response, Exception ex) {
        response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, ex.getMessage());
        response.setEntity(this.getErrorPage(ex));
        return 2;
    }

    public void setAuthorizationURI(String authorizationURI) {
        this.authorizationURI = authorizationURI;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    public void setScope(String[] scope) {
        this.scope = scope;
    }

    public void setTokenURI(String tokenURI) {
        this.tokenURI = tokenURI;
    }

    private String setupState(Response response) {
        String sessionId = UUID.randomUUID().toString();
        byte[] secret = new byte[20];
        this.random.nextBytes(secret);
        String state = Base64.encode((byte[])secret, (boolean)false);
        CookieSetting cs = new CookieSetting("_state", sessionId);
        response.getCookieSettings().add((Object)cs);
        this.getContext().getAttributes().put(sessionId, state);
        return state;
    }

    private void validateState(Request request, Form params) throws Exception {
        String sessionId = request.getCookies().getFirstValue("_state");
        String state = (String)this.getContext().getAttributes().get(sessionId);
        if (state != null && state.equals(params.getFirstValue("state"))) {
            return;
        }
        throw new Exception("The state does not match.");
    }
}

