/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Form;
import org.restlet.ext.oauth.OAuthError;

public class OAuthException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String description;
    private OAuthError error;
    private String errorUri;

    public static OAuthException toOAuthException(Form params) {
        OAuthError error = Enum.valueOf(OAuthError.class, params.getFirstValue("error"));
        OAuthException ex = new OAuthException(error);
        ex.description = params.getFirstValue("error_description");
        ex.errorUri = params.getFirstValue("error_uri");
        return ex;
    }

    public static OAuthException toOAuthException(JSONObject result) throws JSONException {
        OAuthError error = Enum.valueOf(OAuthError.class, result.getString("error"));
        OAuthException ex = new OAuthException(error);
        if (result.has("error_description")) {
            ex.description = result.getString("error_description");
        }
        if (result.has("error_uri")) {
            ex.errorUri = result.getString("error_uri");
        }
        return ex;
    }

    public static OAuthException toOAuthException(Throwable t) {
        if (t instanceof OAuthException) {
            return (OAuthException)t;
        }
        if (t.getCause() instanceof OAuthException) {
            return (OAuthException)t.getCause();
        }
        Logger.getLogger(OAuthException.class.getName()).log(Level.SEVERE, "Internal Server Error", t);
        return new OAuthException(OAuthError.server_error, t.getMessage(), null);
    }

    private OAuthException(OAuthError error) {
        super(error.name());
        this.error = error;
    }

    public OAuthException(OAuthError error, String description, String errorUri) {
        super(error.name());
        this.error = error;
        this.description = description;
        this.errorUri = errorUri;
    }

    public JSONObject createErrorDocument() throws JSONException {
        JSONObject result = new JSONObject();
        result.put("error", (Object)this.error.name());
        if (this.description != null && this.description.length() > 0) {
            result.put("error_description", (Object)this.description);
        }
        if (this.errorUri != null && this.errorUri.length() > 0) {
            result.put("error_uri", (Object)this.errorUri);
        }
        return result;
    }

    public OAuthError getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.description;
    }

    public String getErrorURI() {
        return this.errorUri;
    }
}

