/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

public class OAuthParameters
implements OAuthResourceDefs {
    private Form form = new Form();

    public OAuthParameters add(String name, String value) {
        this.form.add(name, value);
        return this;
    }

    public OAuthParameters code(String code) {
        this.add("code", code);
        return this;
    }

    public OAuthParameters grantType(GrantType grantType) {
        this.add("grant_type", grantType.name());
        return this;
    }

    public OAuthParameters password(String password) {
        this.add("password", password);
        return this;
    }

    public OAuthParameters redirectURI(String redirectURI) {
        this.add("redirect_uri", redirectURI);
        return this;
    }

    public OAuthParameters refreshToken(String refreshToken) {
        this.add("refresh_token", refreshToken);
        return this;
    }

    public OAuthParameters responseType(ResponseType responseType) {
        this.add("response_type", responseType.name());
        return this;
    }

    public OAuthParameters scope(String[] scope) {
        this.add("scope", Scopes.toString(scope));
        return this;
    }

    public OAuthParameters state(String state) {
        this.add("state", state);
        return this;
    }

    protected Form toForm() {
        return this.form;
    }

    public Reference toReference(String uri) {
        String query;
        try {
            query = this.form.encode();
        }
        catch (IOException ex) {
            Logger.getLogger(OAuthParameters.class.getName()).log(Level.SEVERE, null, ex);
            throw new ResourceException((Throwable)ex);
        }
        Reference reference = new Reference(uri);
        reference.setQuery(query);
        return reference;
    }

    public Representation toRepresentation() {
        return this.form.getWebRepresentation();
    }

    public String toString() {
        return this.form.getQueryString();
    }

    public OAuthParameters username(String username) {
        this.add("username", username);
        return this;
    }
}

