/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.ClientManager;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.TokenManager;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public abstract class OAuthServerResource
extends ServerResource
implements OAuthResourceDefs {
    public static final String PARAMETER_DEFAULT_SCOPE = "defaultScope";
    protected volatile ClientManager clients;
    protected volatile TokenManager tokens;

    public static void addCacheDirective(Response response, CacheDirective cacheDirective) {
        ArrayList<CacheDirective> cacheDirectives = response.getCacheDirectives();
        if (cacheDirectives == null) {
            cacheDirectives = new ArrayList<CacheDirective>();
            response.setCacheDirectives(cacheDirectives);
        }
        cacheDirectives.add(cacheDirective);
    }

    public static Representation responseErrorRepresentation(OAuthException ex) {
        try {
            return new JsonRepresentation(ex.createErrorDocument());
        }
        catch (JSONException e) {
            StringRepresentation r = new StringRepresentation((CharSequence)("{\"error\":\"server_error\",\"error_description:\":\"" + e.getLocalizedMessage() + "\"}"));
            r.setMediaType(MediaType.APPLICATION_JSON);
            return r;
        }
    }

    protected void doInit() throws ResourceException {
        super.doInit();
        Context ctx = this.getContext();
        ConcurrentMap attribs = ctx.getAttributes();
        this.clients = (ClientManager)attribs.get(ClientManager.class.getName());
        this.tokens = (TokenManager)attribs.get(TokenManager.class.getName());
        this.getLogger().fine("Found client store = " + this.clients);
    }

    protected Client getClient(Form params) throws OAuthException {
        String clientId = params.getFirstValue("client_id");
        if (clientId == null || clientId.isEmpty()) {
            this.getLogger().warning("Could not find client ID");
            throw new OAuthException(OAuthError.invalid_request, "No client_id parameter found.", null);
        }
        Client client = this.clients.findById(clientId);
        this.getLogger().fine("Client = " + client);
        if (client == null) {
            this.getLogger().warning("Need to register the client : " + clientId);
            throw new OAuthException(OAuthError.invalid_request, "Need to register the client : " + clientId, null);
        }
        return client;
    }

    protected String[] getScope(Form params) throws OAuthException {
        String scope = params.getFirstValue("scope");
        if (scope == null || scope.isEmpty()) {
            Object defaultScope = this.getContext().getAttributes().get(PARAMETER_DEFAULT_SCOPE);
            if (defaultScope == null || defaultScope.toString().isEmpty()) {
                throw new OAuthException(OAuthError.invalid_scope, "Scope has not provided.", null);
            }
            scope = defaultScope.toString();
        }
        return Scopes.parseScope(scope);
    }

    protected String getState(Form params) {
        return params.getFirstValue("state");
    }
}

