/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.net.URI;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class ProtectedClientResource
extends ClientResource
implements OAuthResourceDefs {
    private volatile Token token;
    private volatile boolean useBodyMethod;

    protected ProtectedClientResource() {
    }

    public ProtectedClientResource(ClientResource resource) {
        super(resource);
    }

    public ProtectedClientResource(Context context, Method method, Reference reference) {
        super(context, method, reference);
    }

    public ProtectedClientResource(Context context, Method method, String uri) {
        super(context, method, uri);
    }

    public ProtectedClientResource(Context context, Method method, URI uri) {
        super(context, method, uri);
    }

    public ProtectedClientResource(Context context, Reference reference) {
        super(context, reference);
    }

    public ProtectedClientResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public ProtectedClientResource(Context context, String uri) {
        super(context, uri);
    }

    public ProtectedClientResource(Context context, URI uri) {
        super(context, uri);
    }

    public ProtectedClientResource(Method method, Reference reference) {
        super(method, reference);
    }

    public ProtectedClientResource(Method method, String uri) {
        super(method, uri);
    }

    public ProtectedClientResource(Method method, URI uri) {
        super(method, uri);
    }

    public ProtectedClientResource(Reference reference) {
        super(reference);
    }

    public ProtectedClientResource(Request request, Response response) {
        super(request, response);
    }

    public ProtectedClientResource(String uri) {
        super(uri);
    }

    public ProtectedClientResource(URI uri) {
        super(uri);
    }

    public Token getToken() {
        return this.token;
    }

    public Response handleOutbound(Request request) {
        if (this.token == null) {
            throw new ResourceException(Status.CLIENT_ERROR_UNAUTHORIZED, "Token not found");
        }
        if (this.token.getTokenType().equals("Bearer")) {
            if (this.isUseBodyMethod()) {
                Representation entity = request.getEntity();
                if (entity != null && entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
                    Form form = new Form(entity);
                    form.add("access_token", this.token.getAccessToken());
                    request.setEntity(form.getWebRepresentation());
                } else {
                    request.getResourceRef().addQueryParameter("access_token", this.token.getAccessToken());
                }
            } else {
                ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_OAUTH_BEARER);
                cr.setRawValue(this.token.getAccessToken());
                request.setChallengeResponse(cr);
            }
        } else {
            throw new ResourceException(Status.CLIENT_ERROR_UNAUTHORIZED, "Unsupported token type.");
        }
        return super.handleOutbound(request);
    }

    public boolean isUseBodyMethod() {
        return this.useBodyMethod;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setUseBodyMethod(boolean useBodyMethod) {
        this.useBodyMethod = useBodyMethod;
    }
}

