/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.json.JSONObject;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.ServerToken;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TokenAuthServerResource
extends OAuthServerResource {
    public static final String LOCAL_ACCESS_ONLY = "localOnly";

    @Post(value="json")
    public Representation authenticate(Representation input) throws Exception {
        JSONObject call;
        this.getLogger().fine("In Authenticate resource");
        if (this.isLocalAcessOnly()) {
            String scheme = this.getOriginalRef().getScheme();
            if (!Protocol.RIAP.getSchemeName().equals(scheme)) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Auth server only allows local resource validation");
            }
        }
        if (!(call = new JsonRepresentation(input).getJsonObject()).has("token_type")) {
            throw new OAuthException(OAuthError.invalid_request, "No token_type", null);
        }
        String tokenType = call.getString("token_type");
        if (!tokenType.equals("Bearer")) {
            throw new OAuthException(OAuthError.invalid_request, "Unsupported token_type", null);
        }
        Token token = this.tokens.validateToken(call.get("access_token").toString());
        JSONObject resp = new JSONObject();
        resp.put("username", (Object)((ServerToken)token).getUsername());
        resp.put("scope", (Object)Scopes.toString(token.getScope()));
        return new JsonRepresentation(resp);
    }

    protected void doCatch(Throwable t) {
        OAuthException oex = OAuthException.toOAuthException(t);
        this.getResponse().setStatus(Status.SUCCESS_OK);
        this.getResponse().setEntity(TokenAuthServerResource.responseErrorRepresentation(oex));
    }

    private boolean isLocalAcessOnly() {
        String lo = (String)this.getContext().getAttributes().get(LOCAL_ACCESS_ONLY);
        return lo != null && lo.length() > 0 && Boolean.parseBoolean(lo);
    }
}

