/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import org.restlet.ext.oauth.internal.ServerToken;

public class MemoryToken
implements ServerToken {
    private String accessToken;
    private String clientId;
    private int expirePeriod;
    private String refreshToken;
    private String[] scope;
    private final long timestamp = System.currentTimeMillis();
    private String tokenType;
    private String username;

    protected MemoryToken() {
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public int getExpirePeriod() {
        return this.expirePeriod;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public String[] getScope() {
        return this.scope;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isExpired() {
        long timeout;
        long elapsedTime = System.currentTimeMillis() - this.timestamp;
        return elapsedTime / 1000L > (timeout = (long)this.expirePeriod);
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setExpirePeriod(int expirePeriod) {
        this.expirePeriod = expirePeriod;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setScope(String[] scope) {
        this.scope = scope;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

