/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata;

import freemarker.template.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.odata.Service;
import org.restlet.ext.odata.internal.edm.ComplexType;
import org.restlet.ext.odata.internal.edm.EntityContainer;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.Schema;
import org.restlet.ext.odata.internal.edm.TypeUtils;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;

public class Generator {
    private String serviceClassName;
    private Reference serviceRef;

    public static void main(String[] args) {
        System.out.println("---------------------------");
        System.out.println("OData client code generator");
        System.out.println("---------------------------");
        System.out.println("step 1 - check parameters");
        String errorMessage = null;
        if (args == null || args.length == 0) {
            errorMessage = "Missing mandatory argument: URI of the OData service.";
        }
        File outputDir = null;
        if (errorMessage == null) {
            if (args.length > 1) {
                outputDir = new File(args[1]);
            } else {
                try {
                    outputDir = new File(".").getCanonicalFile();
                }
                catch (IOException e) {
                    errorMessage = "Unable to get the target directory. " + e.getMessage();
                }
            }
            if (outputDir.exists()) {
                System.out.println("step 2 - check the ouput directory");
                if (!outputDir.isDirectory()) {
                    errorMessage = outputDir.getPath() + " is not a valid directory.";
                }
            } else {
                try {
                    System.out.println("step 2 - create the ouput directory");
                    outputDir.mkdirs();
                }
                catch (Throwable e) {
                    errorMessage = "Cannot create " + outputDir.getPath() + " due to: " + e.getMessage();
                }
            }
        }
        if (errorMessage == null) {
            System.out.println("step 3 - get the metadata descriptor");
            String dataServiceUri = null;
            dataServiceUri = args[0].endsWith("$metadata") ? args[0].substring(0, args[0].length() - 10) : (args[0].endsWith("/") ? args[0].substring(0, args[0].length() - 1) : args[0]);
            Service service = new Service(dataServiceUri);
            if (service.getMetadata() == null) {
                errorMessage = "Cannot retrieve the metadata.";
            } else {
                System.out.println("step 4 - generate source code");
                Generator svcUtil = null;
                svcUtil = args.length == 3 ? new Generator(service.getServiceRef(), args[2]) : new Generator(service.getServiceRef());
                try {
                    svcUtil.generate(outputDir);
                    System.out.print("The source code has been generated in directory: ");
                    System.out.println(outputDir.getPath());
                }
                catch (Exception e) {
                    errorMessage = "Cannot generate the source code in directory: " + outputDir.getPath();
                }
            }
        }
        if (errorMessage != null) {
            System.out.println("An error occurred: ");
            System.out.println(errorMessage);
            System.out.println();
            System.out.println("Please check that you provide the following parameters:");
            System.out.println("   - Valid URI for the remote service");
            System.out.println("   - Valid directory path where to generate the files");
            System.out.println("   - Valid name for the generated service class (optional)");
        }
    }

    public Generator(Reference serviceRef) {
        this(serviceRef, null);
    }

    public Generator(Reference serviceRef, String serviceClassName) {
        this.serviceRef = serviceRef;
        if (serviceClassName != null) {
            this.serviceClassName = ReflectUtils.normalize(serviceClassName);
            this.serviceClassName = this.serviceClassName.substring(0, 1).toUpperCase() + this.serviceClassName.substring(1);
        }
    }

    public Generator(String serviceUri) {
        this(serviceUri, null);
    }

    public Generator(String serviceUri, String serviceClassName) {
        this(new Reference(serviceUri), serviceClassName);
    }

    public void generate(File outputDir) throws Exception {
        Service service = new Service(this.serviceRef);
        Metadata metadata = (Metadata)((Object)service.getMetadata());
        if (metadata == null) {
            throw new Exception("Can't get the metadata for this service: " + this.serviceRef);
        }
        Configuration fmc = new Configuration();
        fmc.setDefaultEncoding(CharacterSet.UTF_8.getName());
        String rootTemplates = "clap://class/org/restlet/ext/odata/internal/templates";
        StringRepresentation complexTmpl = new StringRepresentation((CharSequence)new ClientResource(rootTemplates + "/complexType.ftl").get().getText());
        StringRepresentation entityTmpl = new StringRepresentation((CharSequence)new ClientResource(rootTemplates + "/entityType.ftl").get().getText());
        StringRepresentation serviceTmpl = new StringRepresentation((CharSequence)new ClientResource(rootTemplates + "/service.ftl").get().getText());
        for (Schema schema : metadata.getSchemas()) {
            FileOutputStream fos;
            TemplateRepresentation templateRepresentation;
            HashMap<String, Object> dataModel;
            String className;
            if ((schema.getEntityTypes() == null || schema.getEntityTypes().isEmpty()) && (schema.getComplexTypes() == null || schema.getComplexTypes().isEmpty())) continue;
            String packageName = TypeUtils.getPackageName(schema);
            File packageDir = new File(outputDir, packageName.replace(".", System.getProperty("file.separator")));
            packageDir.mkdirs();
            for (EntityType entityType : schema.getEntityTypes()) {
                className = entityType.getClassName();
                dataModel = new HashMap<String, Object>();
                dataModel.put("type", entityType);
                dataModel.put("schema", schema);
                dataModel.put("metadata", (Object)metadata);
                dataModel.put("className", className);
                dataModel.put("packageName", packageName);
                templateRepresentation = new TemplateRepresentation((Representation)entityTmpl, fmc, dataModel, MediaType.TEXT_PLAIN);
                templateRepresentation.setCharacterSet(CharacterSet.UTF_8);
                fos = new FileOutputStream(new File(packageDir, entityType.getClassName() + ".java"));
                templateRepresentation.write((OutputStream)fos);
                fos.flush();
            }
            for (ComplexType complexType : schema.getComplexTypes()) {
                className = complexType.getClassName();
                dataModel = new HashMap();
                dataModel.put("type", complexType);
                dataModel.put("schema", schema);
                dataModel.put("metadata", (Object)metadata);
                dataModel.put("className", className);
                dataModel.put("packageName", packageName);
                templateRepresentation = new TemplateRepresentation((Representation)complexTmpl, fmc, dataModel, MediaType.TEXT_PLAIN);
                templateRepresentation.setCharacterSet(CharacterSet.UTF_8);
                fos = new FileOutputStream(new File(packageDir, complexType.getClassName() + ".java"));
                templateRepresentation.write((OutputStream)fos);
                fos.flush();
            }
        }
        if (metadata.getContainers() != null && !metadata.getContainers().isEmpty()) {
            for (EntityContainer entityContainer : metadata.getContainers()) {
                Schema schema = entityContainer.getSchema();
                StringBuffer className = new StringBuffer();
                if (this.serviceClassName != null) {
                    if (entityContainer.isDefaultEntityContainer()) {
                        className.append(this.serviceClassName);
                    } else if (metadata.getContainers().size() == 1) {
                        className.append(this.serviceClassName);
                    } else {
                        className.append(schema.getNamespace().getNormalizedName().substring(0, 1).toUpperCase());
                        className.append(schema.getNamespace().getNormalizedName().substring(1));
                        className.append("Service");
                    }
                } else {
                    className.append(schema.getNamespace().getNormalizedName().substring(0, 1).toUpperCase());
                    className.append(schema.getNamespace().getNormalizedName().substring(1));
                    className.append("Service");
                }
                HashMap<String, Object> dataModel = new HashMap<String, Object>();
                dataModel.put("schema", schema);
                dataModel.put("metadata", (Object)metadata);
                dataModel.put("className", className);
                dataModel.put("dataServiceUri", this.serviceRef.getTargetRef());
                dataModel.put("entityContainer", entityContainer);
                TemplateRepresentation templateRepresentation = new TemplateRepresentation((Representation)serviceTmpl, fmc, dataModel, MediaType.TEXT_PLAIN);
                templateRepresentation.setCharacterSet(CharacterSet.UTF_8);
                FileOutputStream fos = new FileOutputStream(new File(outputDir, className + ".java"));
                templateRepresentation.write((OutputStream)fos);
                fos.flush();
            }
        }
    }

    public void generate(String outputDir) throws Exception {
        this.generate(new File(outputDir));
    }
}

