/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.FeedReader;
import org.restlet.ext.atom.Link;
import org.restlet.ext.odata.internal.EntryContentHandler;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeedContentHandler<T>
extends FeedReader {
    private int count = -1;
    List<T> entities;
    private Class<?> entityClass;
    private EntityType entityType;
    EntryContentHandler<T> entryHandler;
    private boolean isInFeed;
    private Logger logger;
    private Metadata metadata;
    private boolean parseCount;
    private boolean parseEntry;
    StringBuilder sb = null;

    public FeedContentHandler(Class<?> entityClass, EntityType entityType, Metadata metadata, Logger logger) {
        this.entityClass = entityClass;
        this.entities = new ArrayList<T>();
        this.entityType = entityType;
        this.entryHandler = new EntryContentHandler(entityClass, entityType, metadata, logger);
        this.logger = logger;
        this.metadata = metadata;
    }

    public FeedContentHandler(Class<?> entityClass, Metadata metadata, Logger logger) {
        this.entityClass = entityClass;
        this.entities = new ArrayList<T>();
        this.entryHandler = new EntryContentHandler(entityClass, metadata, logger);
        this.logger = logger;
        this.metadata = metadata;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.parseCount) {
            this.sb.append(ch, start, length);
        } else if (this.parseEntry) {
            this.entryHandler.characters(ch, start, length);
        }
    }

    public boolean closeLink() {
        if (this.parseEntry) {
            return this.entryHandler.closeLink();
        }
        return this.isInFeed;
    }

    public void endContent(Content content) {
        if (this.parseEntry) {
            this.entryHandler.endContent(content);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parseCount) {
            this.count = Integer.parseInt(this.sb.toString());
            this.parseCount = false;
        } else if (this.parseEntry || this.entryHandler != null && localName.equals("entry")) {
            this.entryHandler.endElement(uri, localName, qName);
        }
        if (!this.parseEntry && uri.equals("http://www.w3.org/2005/Atom") && localName.equals("feed")) {
            this.isInFeed = false;
        }
    }

    public void endEntry(Entry entry) {
        if (this.entryHandler.closeEntry(entry)) {
            this.parseEntry = false;
            T entity = this.entryHandler.getEntity();
            if (entity != null) {
                this.entities.add(entity);
            } else {
                this.getLogger().warning("Can't add a null entity.");
            }
        }
    }

    public void endLink(Link link) {
        if (this.parseEntry) {
            this.entryHandler.endLink(link);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.parseEntry) {
            this.entryHandler.endPrefixMapping(prefix);
        }
    }

    public int getCount() {
        return this.count;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Context.getCurrentLogger();
        }
        return this.logger;
    }

    public void startContent(Content content) {
        if (this.parseEntry) {
            this.entryHandler.startContent(content);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (!this.parseEntry && "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(uri) && "count".equals(localName)) {
            this.sb = new StringBuilder();
            this.parseCount = true;
        } else if (this.parseEntry) {
            this.entryHandler.startElement(uri, localName, qName, attrs);
        } else if (uri.equals("http://www.w3.org/2005/Atom") && localName.equals("feed")) {
            this.isInFeed = true;
        }
    }

    public void startEntry(Entry entry) {
        this.parseEntry = true;
        this.entryHandler.startEntry(entry);
    }

    public void startFeed(Feed feed) {
        if (this.entityClass == null) {
            this.entityClass = ReflectUtils.getEntryClass(feed);
        }
        if (this.entityType == null && this.metadata != null) {
            this.entityType = this.metadata.getEntityType(this.entityClass);
        }
    }

    public void startLink(Link link) {
        if (this.parseEntry) {
            this.entryHandler.startLink(link);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.parseEntry) {
            this.entryHandler.startPrefixMapping(prefix, uri);
        }
    }
}

