/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.odata.Service;
import org.restlet.ext.odata.internal.EntryContentHandler;
import org.restlet.ext.odata.internal.FeedContentHandler;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Template;
import org.restlet.routing.Variable;
import org.restlet.util.Series;

public class Query<T>
implements Iterable<T> {
    public static final int TYPE_COMPLEX_TYPE_OR_PROPERTY = 3;
    public static final int TYPE_COMPLEX_TYPE_PROPERTY = 4;
    public static final int TYPE_COMPLEX_TYPE_PROPERTY5 = 5;
    public static final int TYPE_ENTITY = 2;
    public static final int TYPE_ENTITY_SET = 1;
    public static final int TYPE_LINKS = 7;
    public static final int TYPE_PROPERTY_VALUE = 6;
    public static final int TYPE_UNKNOWN = 0;
    private int count = -1;
    private List<T> entities;
    private Class<?> entityClass;
    private EntityType entityType;
    private boolean executed = false;
    private Feed feed;
    private boolean inlineCount;
    private Logger logger;
    private Reference nextPage;
    private String query;
    private Service service;
    private String subpath;

    public Query(Service service, String subpath, Class<T> entityClass) {
        this.entityClass = entityClass;
        this.entityType = service.getMetadata() != null ? ((Metadata)((Object)service.getMetadata())).getEntityType(entityClass) : null;
        this.service = service;
        Reference ref = new Reference(subpath);
        this.subpath = ref.isAbsolute() ? ref.getRelativeRef(service.getServiceRef()).toString(true, true) : subpath;
    }

    public Query<T> addParameter(String name, String value) {
        Query result = new Query(this.getService(), this.getSubpath(), this.entityClass);
        if (this.getQuery() == null || "".equals(this.getQuery())) {
            result.setQuery(name + "=" + value);
        } else {
            result.setQuery(this.getQuery() + "&" + name + "=" + value);
        }
        return result;
    }

    public Query<T> addParameters(Series<Parameter> params) {
        Query result = new Query(this.getService(), this.getSubpath(), this.entityClass);
        StringBuilder builder = new StringBuilder();
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param = (Parameter)params.get(i);
                if (i != 0) continue;
                builder.append(param.getName());
                builder.append("=");
                builder.append(param.getValue());
            }
        }
        if (this.getQuery() == null || "".equals(this.getQuery())) {
            result.setQuery(builder.toString());
        } else {
            result.setQuery(this.getQuery() + "&" + builder.toString());
        }
        return result;
    }

    protected String createTargetUri() {
        String service = this.getService().getServiceRef().toString();
        StringBuilder result = new StringBuilder();
        String subpath = this.getSubpath() == null ? "" : this.getSubpath();
        Reference ref = new Reference(subpath);
        if (ref.isAbsolute()) {
            result = new StringBuilder(subpath);
        } else {
            result = new StringBuilder(service);
            if (service.endsWith("/")) {
                if (subpath.startsWith("/")) {
                    result.append(subpath.substring(1));
                } else {
                    result.append(subpath);
                }
            } else if (subpath.startsWith("/")) {
                result.append(subpath);
            } else {
                result.append("/").append(subpath);
            }
        }
        if (this.getQuery() != null) {
            result.append("?").append(this.getQuery());
        }
        return result.toString();
    }

    public void execute() throws Exception {
        if (!this.isExecuted()) {
            String targetUri = this.createTargetUri();
            ClientResource resource = this.service.createResource(new Reference(targetUri));
            Metadata metadata = (Metadata)((Object)this.service.getMetadata());
            if (metadata == null) {
                throw new Exception("Can't execute the query without the service's metadata.");
            }
            Representation result = null;
            try {
                result = resource.get(MediaType.APPLICATION_ATOM);
            }
            catch (ResourceException e) {
                this.getLogger().warning("Can't execute the query for the following reference: " + targetUri + " due to " + e.getMessage());
                throw e;
            }
            if (resource.getStatus().isSuccess()) {
                switch (this.guessType(targetUri)) {
                    case 1: {
                        FeedContentHandler feedContentHandler = new FeedContentHandler(this.entityClass, this.entityType, metadata, this.getLogger());
                        this.setFeed(new Feed(result, feedContentHandler));
                        this.count = feedContentHandler.getCount();
                        this.entities = feedContentHandler.getEntities();
                        break;
                    }
                    case 2: {
                        EntryContentHandler entryContentHandler = new EntryContentHandler(this.entityClass, this.entityType, metadata, this.getLogger());
                        Feed feed = new Feed();
                        feed.getEntries().add(new Entry(result, entryContentHandler));
                        this.setFeed(feed);
                        this.entities = new ArrayList<T>();
                        if (entryContentHandler.getEntity() == null) break;
                        this.entities.add(entryContentHandler.getEntity());
                        break;
                    }
                    case 0: {
                        StringRepresentation rep = new StringRepresentation((CharSequence)result.getText());
                        String string = rep.getText().substring(0, Math.min(100, rep.getText().length()));
                        if (string.contains("<feed")) {
                            FeedContentHandler feedContentHandler = new FeedContentHandler(this.entityClass, this.entityType, metadata, this.getLogger());
                            this.setFeed(new Feed((Representation)rep, feedContentHandler));
                            this.count = feedContentHandler.getCount();
                            this.entities = feedContentHandler.getEntities();
                            break;
                        }
                        if (!string.contains("<entry")) break;
                        EntryContentHandler entryContentHandler = new EntryContentHandler(this.entityClass, this.entityType, metadata, this.getLogger());
                        Feed feed = new Feed();
                        feed.getEntries().add(new Entry((Representation)rep, entryContentHandler));
                        this.setFeed(feed);
                        this.entities = new ArrayList<T>();
                        if (entryContentHandler.getEntity() == null) break;
                        this.entities.add(entryContentHandler.getEntity());
                    }
                }
            }
            this.service.setLatestRequest(resource.getRequest());
            this.service.setLatestResponse(resource.getResponse());
            this.setExecuted(true);
        }
    }

    public Query<T> expand(String path) {
        return this.addParameter("$expand", path);
    }

    public Query<T> filter(String predicate) {
        return this.addParameter("$filter", predicate);
    }

    public int getCount() {
        if (this.inlineCount) {
            if (!this.isExecuted()) {
                try {
                    this.execute();
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot retrieve inline count value due to: " + e.getMessage());
                }
            }
        } else {
            String targetUri = this.createTargetUri();
            if (this.guessType(targetUri) == 2) {
                targetUri = targetUri.substring(0, targetUri.lastIndexOf("("));
            }
            targetUri = targetUri + "/$count";
            ClientResource resource = this.service.createResource(new Reference(targetUri));
            try {
                Representation result = resource.get();
                this.count = Integer.parseInt(result.getText());
            }
            catch (Exception e) {
                this.getLogger().warning("Cannot parse count value due to: " + e.getMessage());
            }
        }
        return this.count;
    }

    private Feed getFeed() {
        return this.feed;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Context.getCurrentLogger();
        }
        return this.logger;
    }

    public Reference getNextPage() {
        return this.nextPage;
    }

    private String getQuery() {
        return this.query;
    }

    public Service getService() {
        return this.service;
    }

    public String getSubpath() {
        return this.subpath;
    }

    private int guessType(String targetUri) {
        String uri = targetUri;
        int index = targetUri.indexOf("?");
        if (index != -1) {
            uri = uri.substring(0, index);
        }
        int type = 0;
        String entitySet = "{service}.svc/{entitySet}";
        String entity = entitySet + "({keyPredicate})";
        Template t = new Template(entity, 2);
        t.getVariables().put("entitySet", new Variable(1, "", true, false));
        t.getVariables().put("keyPredicate", new Variable(1, "", true, false));
        if (t.match(uri) != -1) {
            return 2;
        }
        t.setPattern(entitySet);
        if (t.match(uri) != -1) {
            return 1;
        }
        return type;
    }

    public Query<T> inlineCount(boolean inlineCount) {
        Query<T> result = null;
        result = inlineCount ? this.addParameter("$inlinecount", "allpages") : this.addParameter("$inlinecount", "none");
        result.inlineCount = inlineCount;
        return result;
    }

    private boolean isExecuted() {
        return this.executed;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = null;
        try {
            this.execute();
            result = this.entities.iterator();
            this.setNextPage(null);
            for (Link link : this.getFeed().getLinks()) {
                if (!Relation.NEXT.equals((Object)link.getRel())) continue;
                this.setNextPage(link.getHref());
                break;
            }
            if (this.getNextPage() != null) {
                result = new EntryIterator<T>(this.service, result, this.getNextPage(), this.entityClass);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Can't parse the content of " + this.createTargetUri(), e);
        }
        return result;
    }

    public Query<T> orderBy(String criteria) {
        return this.addParameter("$orderby", criteria);
    }

    public Query<T> select(String select) {
        return this.addParameter("$select", select);
    }

    private void setExecuted(boolean executed) {
        this.executed = executed;
    }

    private void setFeed(Feed feed) {
        this.feed = feed;
    }

    public void setNextPage(Reference nextPage) {
        this.nextPage = nextPage;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query<T> skip(int rowsCount) {
        return this.addParameter("$skip", Integer.toString(rowsCount));
    }

    public Query<T> skipToken(String token) {
        return this.addParameter("$skiptoken", token);
    }

    public Query<T> top(int rowsCount) {
        return this.addParameter("$top", Integer.toString(rowsCount));
    }

    private class EntryIterator<E>
    implements Iterator<E> {
        private Class<?> entityClass;
        private Iterator<E> iterator;
        private Reference nextPage;
        private Service service;

        public EntryIterator(Service service, Iterator<E> iterator, Reference nextPage, Class<?> entityClass) {
            this.iterator = iterator;
            this.nextPage = nextPage;
            this.service = service;
            this.entityClass = entityClass;
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (this.iterator != null) {
                result = this.iterator.hasNext();
            }
            if (!result && this.nextPage != null) {
                Query<?> query = this.service.createQuery(this.nextPage.toString(), this.entityClass);
                this.iterator = query.iterator();
                if (this.iterator != null) {
                    result = this.iterator.hasNext();
                }
                this.nextPage = null;
            }
            return result;
        }

        @Override
        public E next() {
            E result = null;
            if (this.iterator != null && this.iterator.hasNext()) {
                result = this.iterator.next();
            }
            return result;
        }

        @Override
        public void remove() {
            if (this.iterator != null) {
                this.iterator.remove();
            }
        }
    }
}

