/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.server.ServerManager;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.engine.Engine;
import org.restlet.ext.openid.AttributeExchange;
import org.restlet.ext.openid.internal.OpenIdUser;
import org.restlet.ext.openid.internal.ProviderResult;
import org.restlet.ext.openid.internal.UserSession;

public class Provider {
    public static final String OPENID_MODE = "openid.mode";
    public static final String OPENID_RETURNTO = "openid.return_to";
    public static final String OPENID_REALM = "openid.realm";
    private final Map<String, UserSession> sessions = new HashMap<String, UserSession>();

    public Message fetchAttributes(ParameterList pl) throws Exception {
        if (pl == null) {
            return null;
        }
        Message m = Message.createMessage((ParameterList)pl);
        if (m.hasExtension("http://openid.net/srv/ax/1.0")) {
            return m;
        }
        return null;
    }

    public Message fetchAttributes(UserSession us) throws Exception {
        return this.fetchAttributes(us.getParameterList());
    }

    public Logger getLogger() {
        Logger result = null;
        Context context = Context.getCurrent();
        if (context != null) {
            result = context.getLogger();
        }
        if (result == null) {
            result = Engine.getLogger((Object)this, (String)"org.restlet.ext.openid.OP");
        }
        return result;
    }

    public Set<AttributeExchange> getOptionalAttributes(UserSession us) throws Exception {
        return this.getAttributes(us.getParameterList(), false);
    }

    public Set<AttributeExchange> getOptionalAttributes(ParameterList pl) throws Exception {
        return this.getAttributes(pl, false);
    }

    public Set<AttributeExchange> getRequiredAttributes(UserSession us) throws Exception {
        return this.getAttributes(us.getParameterList(), true);
    }

    public Set<AttributeExchange> getRequiredAttributes(ParameterList pl) throws Exception {
        return this.getAttributes(pl, true);
    }

    public Set<AttributeExchange> getAttributes(ParameterList pl, boolean required) throws Exception {
        Message m = this.fetchAttributes(pl);
        if (m == null) {
            return null;
        }
        MessageExtension me = m.getExtension("http://openid.net/srv/ax/1.0");
        if (me instanceof FetchRequest) {
            FetchRequest fr = (FetchRequest)me;
            Map attrs = fr.getAttributes(required);
            TreeSet<AttributeExchange> toRet = new TreeSet<AttributeExchange>();
            for (Object key : attrs.keySet()) {
                String type = (String)attrs.get(key);
                AttributeExchange ax = AttributeExchange.valueOfType(type);
                if (ax == null) continue;
                toRet.add(ax);
            }
            return toRet;
        }
        return null;
    }

    public Map getOptionalAttributes(Message m) throws Exception {
        FetchRequest req = (FetchRequest)m.getExtension("http://openid.net/srv/ax/1.0");
        return req.getAttributes(false);
    }

    public Map getRequiredAttributes(Message m) throws Exception {
        FetchRequest req = (FetchRequest)m.getExtension("http://openid.net/srv/ax/1.0");
        return req.getAttributes(true);
    }

    public UserSession getSession(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public ProviderResult processOPRequest(ServerManager sm, ParameterList pl, Request req, Response res, UserSession us) {
        Object modeParam = null;
        OpenIdMode mode = null;
        if (pl == null && us != null) {
            pl = us.getParameterList();
        }
        mode = OpenIdMode.valueOf(pl.getParameterValue(OPENID_MODE));
        Engine.getAnonymousLogger().info("processRequest: " + (Object)((Object)mode));
        switch (mode) {
            case associate: {
                Message response = sm.associationResponse(pl);
                return new ProviderResult(ProviderResult.OPR.OK, response.keyValueFormEncoding());
            }
            case checkid_setup: 
            case checkid_immediate: {
                if (us == null || us.getUser() == null) {
                    String session = UUID.randomUUID().toString();
                    this.sessions.put(session, new UserSession(pl));
                    return new ProviderResult(ProviderResult.OPR.GET_USER, session);
                }
                OpenIdUser user = us.getUser();
                Message response = sm.authResponse(pl, user.getClaimedId(), user.getClaimedId(), user.getApproved());
                if (response instanceof DirectError) {
                    return new ProviderResult(ProviderResult.OPR.OK, response.keyValueFormEncoding());
                }
                if (us.getUser().attributes() != null && us.getUser().attributes().size() > 0) {
                    FetchResponse fr = null;
                    fr = FetchResponse.createFetchResponse();
                    for (AttributeExchange attr : us.getUser().attributes()) {
                        String val = us.getUser().getAXValue(attr);
                        if (val == null) continue;
                        try {
                            fr.addAttribute(attr.getName(), attr.getSchema(), val);
                        }
                        catch (MessageException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fr.getAttributes().size() > 0) {
                        try {
                            response.addExtension((MessageExtension)fr);
                            sm.sign((AuthSuccess)response);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                res.redirectSeeOther(response.getDestinationUrl(true));
                return new ProviderResult(ProviderResult.OPR.OK, "");
            }
            case check_authentication: {
                Message response = sm.verify(pl);
                return new ProviderResult(ProviderResult.OPR.OK, response.keyValueFormEncoding());
            }
            case errorMode: {
                DirectError response = DirectError.createDirectError((String)"Unknown request");
                return new ProviderResult(ProviderResult.OPR.OK, response.keyValueFormEncoding());
            }
        }
        return null;
    }

    public static enum OpenIdMode {
        associate,
        check_authentication,
        checkid_immediate,
        checkid_setup,
        errorMode;

    }
}

