/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openid4java.discovery.Identifier;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.ext.openid.AttributeExchange;
import org.restlet.ext.openid.RelayingParty;
import org.restlet.ext.openid.internal.OpenIdUser;
import org.restlet.ext.openid.internal.XRDS;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class OpenIdVerifier
implements Verifier {
    public static final String PROVIDER_FLICKR = "http://flickr.com";
    public static final String PROVIDER_GOOGLE = "https://www.google.com/accounts/o8/id";
    public static final String PROVIDER_MYOPENID = "https://www.myopenid.com/";
    public static final String PROVIDER_MYSPACE = "http://api.myspace.com/openid";
    public static final String PROVIDER_YAHOO = "http://me.yahoo.com";
    private volatile String defaultProvider;
    private final Set<AttributeExchange> optionalAttributes;
    private final Set<AttributeExchange> requiredAttributes;
    private final RelayingParty rp;
    private volatile boolean useDefault = false;

    public OpenIdVerifier() {
        this(null, null);
    }

    public OpenIdVerifier(String defaultProvider) {
        this(defaultProvider, null);
    }

    public OpenIdVerifier(String defaultProvider, RelayingParty rp) {
        this.rp = rp != null ? rp : new RelayingParty();
        this.optionalAttributes = new HashSet<AttributeExchange>();
        this.requiredAttributes = new HashSet<AttributeExchange>();
        if (defaultProvider != null) {
            this.setDefaultProvider(defaultProvider);
        }
    }

    public void addOptionalAttribute(AttributeExchange attributeName) {
        this.optionalAttributes.add(attributeName);
    }

    public void addRequiredAttribute(AttributeExchange attributeName) {
        this.requiredAttributes.add(attributeName);
    }

    public void clearOptionalAttributes() {
        this.optionalAttributes.clear();
    }

    public void clearRequiredAttributes() {
        this.requiredAttributes.clear();
    }

    private String getTarget(Form queryParams, Request request) {
        String target = queryParams.getFirstValue("openid_identifier");
        if (target == null) {
            target = (String)request.getAttributes().get("openid_identifier");
        }
        if (target == null && this.useDefault) {
            target = this.defaultProvider;
        }
        if (target == null) {
            Context.getCurrentLogger().fine("no target or return specified");
        }
        return target;
    }

    public void setDefaultProvider(String provider) {
        this.defaultProvider = provider;
        this.useDefault = true;
    }

    public void setUseDefaultProvider(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public int verify(Request request, Response response) {
        Form params = request.getResourceRef().getQueryAsForm();
        if (this.rp.hasReturnTo(request)) {
            Context.getCurrentLogger().info("handling return");
            HashMap<AttributeExchange, String> axResp = new HashMap<AttributeExchange, String>();
            try {
                Identifier identifier = this.rp.verify(axResp, request, true);
                if (identifier != null && identifier.getIdentifier() != null) {
                    User u = new User(identifier.getIdentifier());
                    if (axResp.size() > 0) {
                        for (Map.Entry entry : axResp.entrySet()) {
                            OpenIdUser.setValueFromAX((AttributeExchange)entry.getKey(), (String)entry.getValue(), u);
                        }
                    }
                    request.getClientInfo().setUser(u);
                    return 4;
                }
                return -1;
            }
            catch (Exception e) {
                Reference ref = new Reference(request.getResourceRef().getHostIdentifier() + request.getResourceRef().getPath());
                Context.getCurrentLogger().info("Generating XRDS Response");
                if (params.getFirst("sessionId") != null) {
                    ref.addQueryParameter("sessionId", params.getFirstValue("sessionId"));
                    ref.addQueryParameter("return", "true");
                }
                try {
                    DomRepresentation rep = XRDS.returnToXrds(ref.toString());
                    response.setEntity((Representation)rep);
                    return 0;
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    return 5;
                }
            }
        }
        String target = this.getTarget(params, request);
        Reference ref = new Reference(request.getResourceRef().getHostIdentifier() + request.getResourceRef().getPath());
        Context.getCurrentLogger().info("generating a authentication request");
        try {
            this.rp.authRequest(target, true, true, ref.toString(), this.optionalAttributes, this.requiredAttributes, request, response);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

