/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid.internal;

import org.restlet.Response;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.util.Series;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XRDS {
    private static final String Type = "Type";
    public static final String TYPE_RETURN_TO = "http://specs.openid.net/auth/2.0/return_to";
    public static final String TYPE_SERVER = "http://specs.openid.net/auth/2.0/server";
    public static final String TYPE_SIGNON = "http://specs.openid.net/auth/2.0/signon";
    private static final String URI = "URI";
    private static final String XRD = "XRD";
    public static final MediaType XRDS = new MediaType("application/xrds+xml", "XRDS Document");

    private static Element createRootAndXrd(DomRepresentation dr) throws Exception {
        dr.setIndenting(true);
        Document d = dr.getDocument();
        Element root = d.createElement("xrds:XRDS");
        root.setAttribute("xmlns:xrds", "xri://$xrds");
        root.setAttribute("xmlns:openid", "http://openid.net/xmlns/1.0");
        root.setAttribute("xmlns", "xri://$xrd*($v*2.0)");
        d.appendChild(root);
        Element xrd = d.createElement(XRD);
        root.appendChild(xrd);
        return xrd;
    }

    private static Element createService(Document d, Element parent, int priority) {
        Element service = d.createElement("Service");
        service.setAttribute("priority", "" + priority);
        parent.appendChild(service);
        return service;
    }

    private static void insert(Document d, Element parent, String node, String text) {
        Element elem = d.createElement(node);
        if (text != null) {
            elem.appendChild(d.createTextNode(text));
        }
        parent.appendChild(elem);
    }

    public static DomRepresentation returnToXrds(String returnTo) throws Exception {
        DomRepresentation dr = new DomRepresentation(XRDS);
        Element xrd = org.restlet.ext.openid.internal.XRDS.createRootAndXrd(dr);
        Element service = org.restlet.ext.openid.internal.XRDS.createService(dr.getDocument(), xrd, 0);
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, Type, TYPE_RETURN_TO);
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, URI, returnTo);
        return dr;
    }

    public static DomRepresentation serverSignon(String serverURI) throws Exception {
        DomRepresentation dr = new DomRepresentation(XRDS);
        Element xrd = org.restlet.ext.openid.internal.XRDS.createRootAndXrd(dr);
        Element service = org.restlet.ext.openid.internal.XRDS.createService(dr.getDocument(), xrd, 0);
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, Type, TYPE_SIGNON);
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, URI, serverURI);
        return dr;
    }

    public static DomRepresentation serverXrds(String serverURI, boolean ax) throws Exception {
        DomRepresentation dr = new DomRepresentation(XRDS);
        Element xrd = org.restlet.ext.openid.internal.XRDS.createRootAndXrd(dr);
        Element service = org.restlet.ext.openid.internal.XRDS.createService(dr.getDocument(), xrd, 0);
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, Type, TYPE_SERVER);
        if (ax) {
            org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, Type, "http://openid.net/srv/ax/1.0");
        }
        org.restlet.ext.openid.internal.XRDS.insert(dr.getDocument(), service, URI, serverURI);
        return dr;
    }

    public static void setXRDSHeader(Response resp, String xrdsLocation) {
        Series headers = (Series)resp.getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            resp.getAttributes().put("org.restlet.http.headers", headers);
        }
        headers.add((Object)new Header("X-XRDS-Location", xrdsLocation));
    }
}

