/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi;

import java.util.HashSet;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.osgi.BaseRestletProvider;
import org.restlet.ext.osgi.DirectoryProvider;
import org.restlet.ext.osgi.ResourceProvider;
import org.restlet.ext.osgi.RestletProvider;
import org.restlet.ext.osgi.RouterProvider;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;

public class BaseRouterProvider
extends BaseRestletProvider
implements RouterProvider {
    private RestletProvider defaultRestletProvider;
    private HashSet<DirectoryProvider> directoryProviders = new HashSet();
    private HashSet<ResourceProvider> resourceProviders = new HashSet();
    private Router router;

    private void attachDirectory(DirectoryProvider directoryProvider) {
        this.router.attach(directoryProvider.getPath(), directoryProvider.getInboundRoot(this.router.getContext()));
    }

    private void attachResource(ResourceProvider resourceProvider) {
        for (String path : resourceProvider.getPaths()) {
            TemplateRoute templateRoute = this.router.attach(path, resourceProvider.getInboundRoot(this.router.getContext()));
            templateRoute.setMatchingMode(resourceProvider.getMatchingMode());
        }
    }

    public void bindDefaultResourceProvider(ResourceProvider resourceProvider) {
        this.defaultRestletProvider = resourceProvider;
        if (this.router != null) {
            this.router.attachDefault(resourceProvider.getInboundRoot(this.router.getContext()));
        }
    }

    public void bindDefaultRouterProvider(RouterProvider routerProvider) {
        this.defaultRestletProvider = routerProvider;
        if (this.router != null) {
            this.router.attachDefault(routerProvider.getInboundRoot(this.router.getContext()));
        }
    }

    public void bindDirectoryProvider(DirectoryProvider directoryProvider) {
        this.directoryProviders.add(directoryProvider);
        if (this.router != null) {
            this.attachDirectory(directoryProvider);
        }
    }

    public void bindResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProviders.add(resourceProvider);
        if (this.router != null) {
            this.attachResource(resourceProvider);
        }
    }

    protected Router createRouter(Context context) {
        return new Router(context);
    }

    @Override
    protected Restlet getFilteredRestlet() {
        return this.router;
    }

    @Override
    public Restlet getInboundRoot(Context context) {
        Restlet inboundRoot;
        if (this.router == null) {
            this.router = this.createRouter(context);
            for (ResourceProvider resourceProvider : this.resourceProviders) {
                this.attachResource(resourceProvider);
            }
            for (DirectoryProvider directoryProvider : this.directoryProviders) {
                this.attachDirectory(directoryProvider);
            }
            if (this.defaultRestletProvider != null) {
                this.router.attachDefault(this.defaultRestletProvider.getInboundRoot(context));
            }
        }
        return (inboundRoot = super.getInboundRoot(context)) != null ? inboundRoot : this.router;
    }

    public void unbindDefaultResourceProvider(ResourceProvider resourceProvider) {
        if (this.defaultRestletProvider == resourceProvider) {
            this.defaultRestletProvider = null;
            if (this.router != null) {
                this.router.detach(resourceProvider.getInboundRoot(this.router.getContext()));
            }
        }
    }

    public void unbindDefaultRouterProvider(RouterProvider routerProvider) {
        if (this.defaultRestletProvider == routerProvider) {
            this.defaultRestletProvider = routerProvider;
            if (this.router != null) {
                this.router.detach(routerProvider.getInboundRoot(this.router.getContext()));
            }
        }
    }

    public void unbindDirectoryProvider(DirectoryProvider directoryProvider) {
        if (this.directoryProviders.remove(directoryProvider) && this.router != null) {
            this.router.detach(directoryProvider.getInboundRoot(this.router.getContext()));
        }
    }

    public void unbindResourceProvider(ResourceProvider resourceProvider) {
        if (this.resourceProviders.remove(resourceProvider) && this.router != null) {
            this.router.detach(resourceProvider.getInboundRoot(this.router.getContext()));
        }
    }
}

