/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.osgi.framework.Bundle;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.LocalClientHelper;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

public class ObapClientHelper
extends LocalClientHelper {
    private static final Map<String, Bundle> BUNDLE_CACHE = new ConcurrentHashMap<String, Bundle>();

    public static boolean register(Bundle bundle) {
        boolean result = false;
        if (bundle != null && bundle.getSymbolicName() != null) {
            BUNDLE_CACHE.put(bundle.getSymbolicName(), bundle);
            result = true;
        }
        return result;
    }

    public static void clear() {
        BUNDLE_CACHE.clear();
    }

    public ObapClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.OBAP);
    }

    protected void handleBundle(Request request, Response response, Bundle bundle) {
        MetadataService metadataService = this.getMetadataService();
        if (request.getMethod().equals((Object)Method.GET) || request.getMethod().equals((Object)Method.HEAD)) {
            String path = request.getResourceRef().getPath();
            URL url = null;
            Date modificationDate = null;
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (bundle != null) {
                url = bundle.getResource(Reference.decode((String)path));
            } else {
                this.getLogger().warning("Unable to get the resource. The selected bundle is null.");
            }
            if (url != null) {
                if (url.getProtocol().equals("file")) {
                    File file = new File(url.getFile());
                    modificationDate = new Date(file.lastModified());
                    if (file.isDirectory()) {
                        url = null;
                    }
                } else if (url.getPath() != null && url.getPath().endsWith("/")) {
                    url = null;
                }
            }
            if (url != null) {
                try {
                    InputRepresentation output = new InputRepresentation(url.openStream(), metadataService.getDefaultMediaType());
                    output.setLocationRef(request.getResourceRef());
                    output.setModificationDate(modificationDate);
                    long timeToLive = this.getTimeToLive();
                    if (timeToLive == 0L) {
                        output.setExpirationDate(null);
                    } else if (timeToLive > 0L) {
                        output.setExpirationDate(new Date(System.currentTimeMillis() + 1000L * timeToLive));
                    }
                    String name = path.substring(path.lastIndexOf(47) + 1);
                    Entity.updateMetadata((String)name, (Variant)output, (boolean)true, (MetadataService)this.getMetadataService());
                    response.setEntity((Representation)output);
                    response.setStatus(Status.SUCCESS_OK);
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to open the representation's input stream", ioe);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }

    protected void handleLocal(Request request, Response response, String decodedPath) {
        String scheme = request.getResourceRef().getScheme();
        if (!scheme.equalsIgnoreCase(Protocol.OBAP.getSchemeName())) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only OBAP is supported.");
        }
        Bundle bundle = BUNDLE_CACHE.get(request.getResourceRef().getAuthority());
        this.getLogger().info("Look for bundle " + request.getResourceRef().getAuthority());
        this.handleBundle(request, response, bundle);
    }
}

