/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi;

import java.util.Dictionary;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.ext.osgi.ApplicationProvider;
import org.restlet.ext.osgi.RouterProvider;

public class BaseApplicationProvider
implements ApplicationProvider {
    private String alias;
    private Application application;
    private RouterProvider routerProvider;

    public void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.alias = (String)properties.get("alias");
    }

    public void bindRouterProvider(RouterProvider routerProvider) {
        this.routerProvider = routerProvider;
        if (this.application != null) {
            this.application.setInboundRoot(routerProvider.getInboundRoot(this.application.getContext()));
        }
    }

    @Override
    public Application createApplication(Context context) {
        this.application = this.doCreateApplication(context);
        if (this.routerProvider != null) {
            this.application.setInboundRoot(this.routerProvider.getInboundRoot(context));
        }
        return this.application;
    }

    protected Application doCreateApplication(Context context) {
        Application app = new Application();
        app.setContext(context);
        return app;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    public HttpContext getContext() {
        return null;
    }

    @Override
    public Dictionary<String, Object> getInitParms() {
        return null;
    }

    public void unbindRouterProvider(RouterProvider routerProvider) {
        if (this.routerProvider == routerProvider) {
            this.routerProvider = null;
        }
    }
}

