/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi;

import java.util.Dictionary;
import org.osgi.service.component.ComponentContext;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.osgi.BaseRestletProvider;
import org.restlet.ext.osgi.DirectoryProvider;
import org.restlet.resource.Directory;

public class BaseDirectoryProvider
extends BaseRestletProvider
implements DirectoryProvider {
    private boolean deeplyAccessible = true;
    private Directory directory;
    private String indexName = "index";
    private boolean modifiable = false;
    private boolean negotiatingContent = true;
    private String path;
    private String rootUri;

    public void activate(ComponentContext context) {
        Boolean negotiatingContent;
        Boolean modifiable;
        Boolean deeplyAccessible;
        Dictionary properties = context.getProperties();
        this.path = (String)properties.get("path");
        this.rootUri = (String)properties.get("rootUri");
        String indexName = (String)properties.get("indexName");
        if (indexName != null) {
            this.indexName = indexName;
        }
        if ((deeplyAccessible = (Boolean)properties.get("deeplyAccessible")) != null) {
            this.deeplyAccessible = deeplyAccessible;
        }
        if ((modifiable = (Boolean)properties.get("modifiable")) != null) {
            this.modifiable = modifiable;
        }
        if ((negotiatingContent = (Boolean)properties.get("negotiatingContent")) != null) {
            this.negotiatingContent = negotiatingContent;
        }
    }

    protected Directory createDirectory(Context context) {
        Directory directory = new Directory(context, this.rootUri);
        directory.setIndexName(this.indexName);
        directory.setDeeplyAccessible(this.deeplyAccessible);
        directory.setModifiable(this.modifiable);
        directory.setNegotiatingContent(this.negotiatingContent);
        return directory;
    }

    @Override
    protected Restlet getFilteredRestlet() {
        return this.directory;
    }

    @Override
    public Restlet getInboundRoot(Context context) {
        Restlet inboundRoot;
        if (this.directory == null) {
            this.directory = this.createDirectory(context);
        }
        return (inboundRoot = super.getInboundRoot(context)) != null ? inboundRoot : this.directory;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

