/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi;

import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;

public class DynamicFinder
extends Finder {
    private Bundle bundle;
    private String className;
    private LogService logService;
    private Class<? extends ServerResource> targetClass;

    public DynamicFinder(Bundle bundle, String className) {
        this(bundle, className, null);
    }

    public DynamicFinder(Bundle bundle, String className, LogService logService) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        this.bundle = bundle;
        this.className = className;
        this.logService = logService;
    }

    public Class<? extends ServerResource> getTargetClass() {
        block3: {
            if (this.targetClass == null) {
                try {
                    this.targetClass = this.bundle.loadClass(this.className);
                }
                catch (ClassNotFoundException e) {
                    if (this.logService == null) break block3;
                    this.logService.log(1, "Failed to load class: '" + this.className + "'", (Throwable)e);
                }
            }
        }
        return this.targetClass;
    }
}

