/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.osgi.internal;

import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.restlet.ext.osgi.ObapClientHelper;

public class Activator
implements BundleActivator {
    private static Logger logger = Logger.getLogger("org.restlet.ext.osgi");

    public void start(BundleContext context) throws Exception {
        for (Bundle bundle : context.getBundles()) {
            if (ObapClientHelper.register(bundle)) continue;
            logger.warning("OBAP client helper can't register this bundle: " + bundle.getBundleId() + " at location " + bundle.getLocation());
        }
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 1: {
                        if (ObapClientHelper.register(event.getBundle())) break;
                        logger.warning("OBAP client helper can't register this bundle: " + event.getBundle().getBundleId() + " at location " + event.getBundle().getLocation());
                    }
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        ObapClientHelper.clear();
    }
}

