/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.raml;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.raml.RamlSpecificationRestlet;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;

public class RamlApplication
extends Application {
    private boolean documented;

    private static Router getNextRouter(Restlet current) {
        Router result = null;
        if (current instanceof Router) {
            result = (Router)current;
        } else if (current instanceof Filter) {
            result = RamlApplication.getNextRouter(((Filter)current).getNext());
        }
        return result;
    }

    private static boolean isDocumented(Restlet current) {
        boolean documented = false;
        Router router = null;
        if (current instanceof Router) {
            router = (Router)current;
            for (Route route : router.getRoutes()) {
                if (!RamlApplication.isDocumented(route.getNext())) continue;
                documented = true;
                break;
            }
        } else if (current instanceof Filter) {
            documented = RamlApplication.isDocumented(((Filter)current).getNext());
        } else if (current instanceof RamlSpecificationRestlet) {
            documented = true;
        }
        return documented;
    }

    public void attachRamlDocumentationRestlet(Router router, String ramlPath, Restlet ramlRestlet) {
        router.attach(ramlPath, ramlRestlet);
    }

    public void attachRamlSpecificationRestlet(Router router) {
        RamlSpecificationRestlet restlet = this.getRamlSpecificationRestlet(this.getContext());
        this.attachRamlDocumentationRestlet(router, "/raml", restlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Restlet getInboundRoot() {
        Restlet inboundRoot = super.getInboundRoot();
        if (!this.documented) {
            RamlApplication ramlApplication = this;
            synchronized (ramlApplication) {
                if (!this.documented) {
                    Router rootRouter = RamlApplication.getNextRouter(inboundRoot);
                    this.documented = RamlApplication.isDocumented((Restlet)rootRouter);
                    if (!this.documented) {
                        this.attachRamlSpecificationRestlet(rootRouter);
                        this.documented = true;
                    }
                }
            }
        }
        return inboundRoot;
    }

    public RamlSpecificationRestlet getRamlSpecificationRestlet(Context context) {
        RamlSpecificationRestlet result = new RamlSpecificationRestlet(context);
        result.setApiInboundRoot(this);
        return result;
    }
}

