/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.raml.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.raml.internal.RamlUtils;
import org.restlet.ext.raml.internal.TranslationException;

public abstract class RamlTranslator {
    protected static Logger LOGGER = Logger.getLogger(RamlTranslator.class.getName());

    private static PathVariable getPathVariable(String paramName, UriParameter uriParameter) {
        PathVariable pathVariable = new PathVariable();
        pathVariable.setName(paramName);
        pathVariable.setDescription(uriParameter.getDescription());
        pathVariable.setArray(uriParameter.isRepeat());
        return pathVariable;
    }

    private static List<PathVariable> getPathVariables(Resource resource) {
        ArrayList<PathVariable> pathVariables = new ArrayList<PathVariable>();
        for (Map.Entry entry : resource.getUriParameters().entrySet()) {
            pathVariables.add(RamlTranslator.getPathVariable((String)entry.getKey(), (UriParameter)entry.getValue()));
        }
        if (resource.getParentResource() != null) {
            pathVariables.addAll(RamlTranslator.getPathVariables(resource.getParentResource()));
        }
        return pathVariables;
    }

    public static Raml getRaml(Definition definition) {
        Raml raml = new Raml();
        ObjectMapper m = new ObjectMapper();
        if (definition.getVersion() != null) {
            raml.setVersion(definition.getVersion());
        }
        if (definition.getEndpoint() != null) {
            raml.setBaseUri(definition.getEndpoint());
        } else {
            raml.setBaseUri("http://example.com");
        }
        raml.setTitle(definition.getContract().getName());
        raml.setResources(new HashMap());
        ArrayList<String> paths = new ArrayList<String>();
        for (org.restlet.ext.apispark.internal.model.Resource resource : definition.getContract().getResources()) {
            Resource ramlResource = new Resource();
            if (resource.getName() != null) {
                ramlResource.setDisplayName(resource.getName());
            } else {
                ramlResource.setDisplayName(RamlUtils.processResourceName(resource.getResourcePath()));
            }
            ramlResource.setDescription(resource.getDescription());
            ramlResource.setParentUri("");
            ramlResource.setRelativeUri(resource.getResourcePath());
            UriParameter uiParam = new UriParameter();
            ramlResource.setUriParameters(new HashMap());
            for (PathVariable pathVariable : resource.getPathVariables()) {
                uiParam.setDisplayName(pathVariable.getName());
                uiParam.setDescription(pathVariable.getDescription());
                uiParam.setRepeat(pathVariable.isArray());
                uiParam.setType(RamlUtils.getParamType(pathVariable.getType()));
                ramlResource.getUriParameters().put(pathVariable.getName(), uiParam);
            }
            ramlResource.setActions(new HashMap());
            for (Operation operation : resource.getOperations()) {
                Action action = new Action();
                action.setDescription(operation.getDescription());
                action.setResource(ramlResource);
                MimeType ramlInRepresentation = new MimeType();
                if (operation.getInRepresentation() != null) {
                    ramlInRepresentation.setType(operation.getInRepresentation().getType());
                    if (RamlUtils.isPrimitiveType(operation.getInRepresentation().getType())) {
                        Property inRepresentationPrimitive = new Property();
                        inRepresentationPrimitive.setName("");
                        inRepresentationPrimitive.setType(operation.getInRepresentation().getType());
                        SimpleTypeSchema inRepresentationSchema = RamlUtils.generatePrimitiveSchema(inRepresentationPrimitive);
                        try {
                            ramlInRepresentation.setSchema(m.writeValueAsString((Object)inRepresentationSchema));
                        }
                        catch (JsonProcessingException e) {
                            LOGGER.log(Level.WARNING, "Error when setting mime type schema.", e);
                        }
                    } else {
                        ramlInRepresentation.setSchema(operation.getInRepresentation().getType());
                    }
                    action.setBody(new HashMap());
                    for (String mediaType : operation.getConsumes()) {
                        action.getBody().put(mediaType, ramlInRepresentation);
                    }
                }
                action.setQueryParameters(new HashMap());
                for (org.restlet.ext.apispark.internal.model.QueryParameter queryParameter : operation.getQueryParameters()) {
                    QueryParameter ramlQueryParameter = new QueryParameter();
                    ramlQueryParameter.setDisplayName(queryParameter.getName());
                    ramlQueryParameter.setDescription(queryParameter.getDescription());
                    ramlQueryParameter.setRequired(queryParameter.isRequired());
                    ramlQueryParameter.setDefaultValue(queryParameter.getDefaultValue());
                    ramlQueryParameter.setRepeat(queryParameter.isAllowMultiple());
                    action.getQueryParameters().put(queryParameter.getName(), ramlQueryParameter);
                }
                Response ramlResponse = new Response();
                action.setResponses(new HashMap());
                for (org.restlet.ext.apispark.internal.model.Response response : operation.getResponses()) {
                    ramlResponse = new Response();
                    ramlResponse.setDescription(response.getDescription());
                    ramlResponse.setBody(new HashMap());
                    MimeType ramlOutRepresentation = new MimeType();
                    if (Status.isSuccess((int)response.getCode()) && operation.getOutRepresentation() != null && operation.getOutRepresentation().getType() != null) {
                        if (RamlUtils.isPrimitiveType(operation.getOutRepresentation().getType())) {
                            Property outRepresentationPrimitive = new Property();
                            outRepresentationPrimitive.setName("");
                            outRepresentationPrimitive.setType(operation.getOutRepresentation().getType());
                            SimpleTypeSchema outRepresentationSchema = RamlUtils.generatePrimitiveSchema(outRepresentationPrimitive);
                            try {
                                ramlOutRepresentation.setSchema(m.writeValueAsString((Object)outRepresentationSchema));
                            }
                            catch (JsonProcessingException e) {
                                LOGGER.log(Level.WARNING, "Error when setting mime type schema.", e);
                            }
                        } else {
                            ramlOutRepresentation.setSchema(operation.getOutRepresentation().getType());
                        }
                    }
                    for (String mediaType : operation.getProduces()) {
                        ramlResponse.getBody().put(mediaType, ramlOutRepresentation);
                    }
                    action.getResponses().put(Integer.toString(response.getCode()), ramlResponse);
                }
                ramlResource.getActions().put(RamlUtils.getActionType(operation.getMethod()), action);
            }
            paths.add(resource.getResourcePath());
            raml.getResources().put(ramlResource.getRelativeUri(), ramlResource);
        }
        raml.setSchemas(new ArrayList());
        HashMap<String, String> schemas = new HashMap<String, String>();
        raml.getSchemas().add(schemas);
        for (Representation representation : definition.getContract().getRepresentations()) {
            if (RamlUtils.isPrimitiveType(representation.getName())) continue;
            try {
                schemas.put(representation.getName(), m.writeValueAsString((Object)RamlUtils.generateSchema(representation)));
            }
            catch (JsonProcessingException e) {
                LOGGER.log(Level.WARNING, "Error when putting mime type schema for representation: " + representation.getName(), e);
            }
        }
        return raml;
    }

    public static Representation getRepresentationByName(List<Representation> representations, String name) {
        if (name != null) {
            for (Representation repr : representations) {
                if (!name.equals(repr.getName())) continue;
                return repr;
            }
        }
        return null;
    }

    private static List<org.restlet.ext.apispark.internal.model.Resource> getResource(String resourceName, Resource resource, List<PathVariable> rootPathVariables) {
        ArrayList<org.restlet.ext.apispark.internal.model.Resource> rwadResources = new ArrayList<org.restlet.ext.apispark.internal.model.Resource>();
        org.restlet.ext.apispark.internal.model.Resource rwadResource = new org.restlet.ext.apispark.internal.model.Resource();
        rwadResource.setDescription(resource.getDescription());
        rwadResource.setName(resourceName);
        rwadResource.setResourcePath(resource.getUri());
        rwadResource.setPathVariables(RamlTranslator.getPathVariables(resource));
        rwadResource.getPathVariables().addAll(rootPathVariables);
        for (Map.Entry entry : resource.getActions().entrySet()) {
            Action action = (Action)entry.getValue();
            Operation operation = new Operation();
            operation.setDescription(action.getDescription());
            operation.setMethod(((ActionType)entry.getKey()).name().toString());
        }
        rwadResources.add(rwadResource);
        for (Map.Entry entry : resource.getResources().entrySet()) {
            rwadResources.addAll(RamlTranslator.getResource(RamlUtils.processResourceName(((Resource)entry.getValue()).getUri()), (Resource)entry.getValue(), rootPathVariables));
        }
        return rwadResources;
    }

    public static Definition translate(Raml raml) throws TranslationException {
        Definition def = new Definition();
        if (raml.getVersion() != null) {
            def.setVersion(raml.getVersion().substring(1));
            def.setEndpoint(raml.getBaseUri().replace("{version}", raml.getVersion()));
        } else {
            def.setEndpoint(raml.getBaseUri());
        }
        def.setContract(new Contract());
        def.getContract().setName(raml.getTitle());
        ArrayList<PathVariable> rootPathVariables = new ArrayList<PathVariable>();
        for (Map.Entry entry : raml.getBaseUriParameters().entrySet()) {
            rootPathVariables.add(RamlTranslator.getPathVariable((String)entry.getKey(), (UriParameter)entry.getValue()));
        }
        for (Map schema : raml.getSchemas()) {
            for (Map.Entry entry : schema.entrySet()) {
                Representation representation = new Representation();
                representation.setName((String)entry.getKey());
                representation.setDescription((String)entry.getValue());
                def.getContract().getRepresentations().add(representation);
            }
        }
        for (Map.Entry entry : raml.getResources().entrySet()) {
            Resource resource = (Resource)entry.getValue();
            def.getContract().getResources().addAll(RamlTranslator.getResource(RamlUtils.processResourceName(resource.getUri()), resource, rootPathVariables));
        }
        return def;
    }

    private RamlTranslator() {
    }
}

