/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.raml.internal.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.PropertyInfo;
import org.restlet.ext.apispark.internal.info.RepresentationInfo;
import org.restlet.ext.apispark.internal.info.ResourceInfo;
import org.restlet.ext.apispark.internal.info.ResponseInfo;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Entity;
import org.restlet.ext.apispark.internal.model.Header;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.raml.internal.reflect.ReflectUtils;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;

public class Introspector {
    protected static Logger LOGGER = Logger.getLogger(Introspector.class.getName());
    private Definition definition;

    private static void addRepresentations(Map<String, RepresentationInfo> mapReps, List<RepresentationInfo> representations) {
        if (representations != null) {
            for (RepresentationInfo r : representations) {
                if (mapReps.containsKey(r.getIdentifier())) continue;
                mapReps.put(r.getIdentifier(), r);
            }
        }
    }

    private static void addResources(ApplicationInfo application, Contract contract, List<ResourceInfo> resources, String basePath, Map<String, RepresentationInfo> mapReps) {
        for (ResourceInfo ri : resources) {
            Resource resource = new Resource();
            resource.setDescription(Introspector.toString(ri.getDocumentations()));
            resource.setName(ri.getIdentifier());
            if (ri.getPath() == null) {
                resource.setResourcePath("/");
            } else if (!ri.getPath().startsWith("/")) {
                resource.setResourcePath("/" + ri.getPath());
            } else {
                resource.setResourcePath(ri.getPath());
            }
            resource.setPathVariables(new ArrayList());
            for (ParameterInfo pi : ri.getParameters()) {
                if (!ParameterStyle.TEMPLATE.equals((Object)pi.getStyle())) continue;
                PathVariable pathVariable = new PathVariable();
                pathVariable.setDescription(Introspector.toString(pi.getDocumentations()));
                pathVariable.setName(pi.getName());
                resource.getPathVariables().add(pathVariable);
            }
            if (!ri.getChildResources().isEmpty()) {
                Introspector.addResources(application, contract, ri.getChildResources(), resource.getResourcePath(), mapReps);
            }
            LOGGER.fine("Resource " + ri.getPath() + " added.");
            if (ri.getMethods().isEmpty()) {
                LOGGER.warning("Resource " + ri.getIdentifier() + " has no methods.");
                continue;
            }
            resource.setOperations(new ArrayList());
            for (MethodInfo mi : ri.getMethods()) {
                Entity entity;
                QueryParameter queryParameter;
                Header header;
                String mediaType;
                String methodName = mi.getMethod().getName();
                if ("OPTIONS".equals(methodName) || "PATCH".equals(methodName)) {
                    LOGGER.fine("Method " + methodName + " ignored.");
                    continue;
                }
                LOGGER.fine("Method " + methodName + " added.");
                Operation operation = new Operation();
                operation.setDescription(Introspector.toString(mi.getDocumentations()));
                operation.setName(methodName);
                operation.setMethod(mi.getMethod().getName());
                if (mi.getRequest() != null && mi.getRequest().getRepresentations() != null) {
                    List consumed = mi.getRequest().getRepresentations();
                    for (RepresentationInfo reprInfo : consumed) {
                        mediaType = reprInfo.getMediaType().getName();
                        operation.getConsumes().add(mediaType);
                    }
                }
                if (mi.getResponse() != null && mi.getResponse().getRepresentations() != null) {
                    List produced = mi.getResponse().getRepresentations();
                    for (RepresentationInfo reprInfo : produced) {
                        mediaType = reprInfo.getMediaType().getName();
                        operation.getProduces().add(mediaType);
                    }
                }
                operation.setHeaders(new ArrayList());
                operation.setQueryParameters(new ArrayList());
                if (mi.getRequest() != null) {
                    for (ParameterInfo pi : mi.getRequest().getParameters()) {
                        if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                            header = new Header();
                            header.setAllowMultiple(pi.isRepeating());
                            header.setDefaultValue(pi.getDefaultValue());
                            header.setDescription(Introspector.toString(pi.getDocumentations(), pi.getDefaultValue()));
                            header.setName(pi.getName());
                            header.setEnumeration(new ArrayList());
                            header.setRequired(pi.isRequired());
                            operation.getHeaders().add(header);
                            continue;
                        }
                        if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                        queryParameter = new QueryParameter();
                        queryParameter.setAllowMultiple(pi.isRepeating());
                        queryParameter.setDefaultValue(pi.getDefaultValue());
                        queryParameter.setDescription(Introspector.toString(pi.getDocumentations(), pi.getDefaultValue()));
                        queryParameter.setName(pi.getName());
                        queryParameter.setEnumeration(new ArrayList());
                        queryParameter.setRequired(pi.isRequired());
                        operation.getQueryParameters().add(queryParameter);
                    }
                }
                for (ParameterInfo pi : mi.getParameters()) {
                    if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                        header = new Header();
                        header.setAllowMultiple(pi.isRepeating());
                        header.setDefaultValue(pi.getDefaultValue());
                        header.setDescription(Introspector.toString(pi.getDocumentations(), pi.getDefaultValue()));
                        header.setName(pi.getName());
                        header.setEnumeration(new ArrayList());
                        header.setRequired(pi.isRequired());
                        operation.getHeaders().add(header);
                        continue;
                    }
                    if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                    queryParameter = new QueryParameter();
                    queryParameter.setAllowMultiple(pi.isRepeating());
                    queryParameter.setDefaultValue(pi.getDefaultValue());
                    queryParameter.setDescription(Introspector.toString(pi.getDocumentations(), pi.getDefaultValue()));
                    queryParameter.setName(pi.getName());
                    queryParameter.setEnumeration(new ArrayList());
                    queryParameter.setRequired(pi.isRequired());
                    operation.getQueryParameters().add(queryParameter);
                }
                if (mi.getRequest() != null && mi.getRequest().getRepresentations() != null && !mi.getRequest().getRepresentations().isEmpty()) {
                    Introspector.addRepresentations(mapReps, mi.getRequest().getRepresentations());
                    entity = new Entity();
                    entity.setType(((RepresentationInfo)mi.getRequest().getRepresentations().get(0)).getType().getSimpleName());
                    entity.setArray(((RepresentationInfo)mi.getRequest().getRepresentations().get(0)).isCollection());
                    operation.setInRepresentation(entity);
                }
                if (mi.getResponses() != null && !mi.getResponses().isEmpty()) {
                    operation.setResponses(new ArrayList());
                    entity = new Entity();
                    if (!mi.getResponse().getRepresentations().isEmpty()) {
                        entity.setType(((RepresentationInfo)mi.getResponse().getRepresentations().get(0)).getType().getSimpleName());
                        entity.setArray(((RepresentationInfo)mi.getResponse().getRepresentations().get(0)).isCollection());
                    }
                    operation.setOutRepresentation(entity);
                    for (ResponseInfo rio : mi.getResponses()) {
                        Introspector.addRepresentations(mapReps, rio.getRepresentations());
                        if (rio.getStatuses().isEmpty()) continue;
                        Status status = (Status)rio.getStatuses().get(0);
                        org.restlet.ext.apispark.internal.model.Response response = new org.restlet.ext.apispark.internal.model.Response();
                        response.setEntity(entity);
                        response.setCode(status.getCode());
                        response.setName(Introspector.toString(rio.getDocumentations()));
                        response.setDescription(Introspector.toString(rio.getDocumentations()));
                        response.setMessage(status.getDescription());
                        operation.getResponses().add(response);
                    }
                }
                resource.getOperations().add(operation);
            }
            contract.getResources().add(resource);
        }
    }

    protected static ApplicationInfo getApplicationInfo(Application application, Reference baseRef) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        if (application.getName() != null && !application.getName().isEmpty()) {
            DocumentationInfo doc = null;
            if (applicationInfo.getDocumentations().isEmpty()) {
                doc = new DocumentationInfo();
                applicationInfo.getDocumentations().add(doc);
            } else {
                doc = (DocumentationInfo)applicationInfo.getDocumentations().get(0);
            }
            applicationInfo.setName(application.getName());
            doc.setTitle(application.getName());
        }
        applicationInfo.getResources().setBaseRef(baseRef);
        applicationInfo.getResources().setResources(Introspector.getResourceInfos(applicationInfo, Introspector.getNextRouter(application.getInboundRoot()), "/"));
        return applicationInfo;
    }

    private static Application getNextApplication(Restlet current) {
        Application result;
        block2: {
            Route route;
            block3: {
                block1: {
                    result = null;
                    if (!(current instanceof Application)) break block1;
                    result = (Application)current;
                    break block2;
                }
                if (!(current instanceof Filter)) break block3;
                result = Introspector.getNextApplication(((Filter)current).getNext());
                break block2;
            }
            if (!(current instanceof Router)) break block2;
            Router router = (Router)current;
            Iterator i$ = router.getRoutes().iterator();
            while (i$.hasNext() && (result = Introspector.getNextApplication((route = (Route)i$.next()).getNext())) == null) {
            }
        }
        return result;
    }

    private static Router getNextRouter(Restlet current) {
        Router result = null;
        if (current instanceof Router) {
            result = (Router)current;
        } else if (current instanceof Filter) {
            result = Introspector.getNextRouter(((Filter)current).getNext());
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Filter filter, String path) {
        return Introspector.getResourceInfo(applicationInfo, filter.getNext(), path);
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Finder finder, String path) {
        ResourceInfo result = null;
        Finder resource = null;
        if (finder instanceof Directory) {
            resource = finder;
        } else {
            ServerResource sr = finder.find(null, null);
            if (sr != null) {
                Request request = new Request();
                Response response = new Response(request);
                sr.setRequest(request);
                sr.setResponse(response);
                sr.updateAllowedMethods();
                resource = sr;
            }
        }
        if (resource != null) {
            result = new ResourceInfo();
            ResourceInfo.describe((ApplicationInfo)applicationInfo, (ResourceInfo)result, (Object)resource, (String)path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Restlet restlet, String path) {
        ResourceInfo result = null;
        if (restlet instanceof Finder) {
            result = Introspector.getResourceInfo(applicationInfo, (Finder)restlet, path);
        } else if (restlet instanceof Router) {
            result = new ResourceInfo();
            result.setPath(path);
            result.setChildResources(Introspector.getResourceInfos(applicationInfo, (Router)restlet, path));
        } else if (restlet instanceof Filter) {
            result = Introspector.getResourceInfo(applicationInfo, (Filter)restlet, path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Route route, String basePath) {
        ResourceInfo result = null;
        if (route instanceof TemplateRoute) {
            TemplateRoute templateRoute = (TemplateRoute)route;
            String path = templateRoute.getTemplate().getPattern();
            path = path.startsWith("/") && basePath.endsWith("/") ? basePath + path.substring(1) : basePath + path;
            result = Introspector.getResourceInfo(applicationInfo, route.getNext(), path);
        }
        return result;
    }

    private static List<ResourceInfo> getResourceInfos(ApplicationInfo applicationInfo, Router router, String path) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        if (router != null) {
            ResourceInfo resourceInfo;
            for (Route route : router.getRoutes()) {
                ResourceInfo resourceInfo2 = Introspector.getResourceInfo(applicationInfo, route, path);
                if (resourceInfo2 == null) continue;
                result.add(resourceInfo2);
            }
            if (router.getDefaultRoute() != null && (resourceInfo = Introspector.getResourceInfo(applicationInfo, router.getDefaultRoute(), path)) != null) {
                result.add(resourceInfo);
            }
        }
        return result;
    }

    private static Definition toDefinition(ApplicationInfo application) {
        Definition result = null;
        if (application != null) {
            RepresentationInfo r;
            result = new Definition();
            result.setVersion(application.getVersion());
            if (application.getResources().getBaseRef() != null) {
                result.setEndpoint(application.getResources().getBaseRef().toString());
            }
            Contract contract = new Contract();
            result.setContract(contract);
            contract.setDescription(Introspector.toString(application.getDocumentations()));
            contract.setName(application.getName());
            if (contract.getName() == null || contract.getName().isEmpty()) {
                contract.setName(application.getClass().getName());
                LOGGER.log(Level.WARNING, "Please provide a name to your application, used " + contract.getName() + " by default.");
            }
            LOGGER.fine("Contract " + contract.getName() + " added.");
            contract.setResources(new ArrayList());
            HashMap<String, RepresentationInfo> mapReps = new HashMap<String, RepresentationInfo>();
            Introspector.addResources(application, contract, application.getResources().getResources(), result.getEndpoint(), mapReps);
            ArrayList<String> protocols = new ArrayList<String>();
            for (ConnectorHelper helper : Engine.getInstance().getRegisteredServers()) {
                for (Protocol protocol : helper.getProtocols()) {
                    if (protocols.contains(protocol.getName())) continue;
                    LOGGER.fine("Protocol " + protocol.getName() + " added.");
                    protocols.add(protocol.getName());
                }
            }
            contract.setRepresentations(new ArrayList());
            for (RepresentationInfo ri : application.getRepresentations()) {
                if (mapReps.containsKey(ri.getIdentifier())) continue;
                mapReps.put(ri.getIdentifier(), ri);
            }
            ArrayList<RepresentationInfo> toBeAdded = new ArrayList<RepresentationInfo>();
            for (RepresentationInfo ri : mapReps.values()) {
                Class parentType;
                if (ri.isRaw()) continue;
                if (ri.isCollection() && !mapReps.containsKey(ri.getType().getName())) {
                    RepresentationInfo r2 = new RepresentationInfo(ri.getMediaType());
                    r2.setType(ri.getType());
                    toBeAdded.add(r2);
                }
                if ((parentType = ri.getType().getSuperclass()) != null && ReflectUtils.isJdkClass(parentType)) {
                    parentType = null;
                }
                if (parentType != null && !mapReps.containsKey(parentType.getName())) {
                    RepresentationInfo r3 = new RepresentationInfo(ri.getMediaType());
                    r3.setType(parentType);
                    toBeAdded.add(r3);
                }
                for (PropertyInfo pi : ri.getProperties()) {
                    if (pi.getType() == null || mapReps.containsKey(pi.getType().getName()) || toBeAdded.contains(pi.getType())) continue;
                    r = new RepresentationInfo(ri.getMediaType());
                    r.setType(pi.getType());
                    toBeAdded.add(r);
                }
            }
            while (!toBeAdded.isEmpty()) {
                RepresentationInfo[] tab = new RepresentationInfo[toBeAdded.size()];
                toBeAdded.toArray(tab);
                toBeAdded.clear();
                for (int i = 0; i < tab.length; ++i) {
                    RepresentationInfo current = tab[i];
                    if (current.isRaw() || ReflectUtils.isJdkClass(current.getType()) || mapReps.containsKey(current.getName())) continue;
                    RepresentationInfo ri = RepresentationInfo.introspect((Class)current.getType(), null, (MediaType)current.getMediaType());
                    mapReps.put(ri.getIdentifier(), ri);
                    Class parentType = ri.getType().getSuperclass();
                    if (parentType != null && ReflectUtils.isJdkClass(parentType)) {
                        parentType = null;
                    }
                    if (parentType != null && !mapReps.containsKey(parentType.getName())) {
                        r = new RepresentationInfo(ri.getMediaType());
                        r.setType(parentType);
                        toBeAdded.add(r);
                    }
                    for (PropertyInfo prop : ri.getProperties()) {
                        if (prop.getType() == null || mapReps.containsKey(prop.getType().getName()) || toBeAdded.contains(prop.getType())) continue;
                        RepresentationInfo r4 = new RepresentationInfo(ri.getMediaType());
                        r4.setType(prop.getType());
                        toBeAdded.add(r4);
                    }
                }
            }
            for (RepresentationInfo ri : mapReps.values()) {
                if (ri.isCollection()) continue;
                LOGGER.fine("Representation " + ri.getName() + " added.");
                Representation rep = new Representation();
                rep.setDescription(Introspector.toString(ri.getDocumentations()));
                rep.setName(ri.getName());
                rep.setProperties(new ArrayList());
                for (PropertyInfo pi : ri.getProperties()) {
                    LOGGER.fine("Property " + pi.getName() + " added.");
                    Property p = new Property();
                    p.setDefaultValue(pi.getDefaultValue());
                    p.setDescription(pi.getDescription());
                    p.setMax(pi.getMax());
                    p.setMaxOccurs(pi.getMaxOccurs());
                    p.setMin(pi.getMin());
                    p.setMinOccurs(pi.getMinOccurs());
                    p.setName(pi.getName());
                    p.setEnumeration(pi.getEnumeration());
                    if (pi.getType() != null) {
                        p.setType(pi.getType().getSimpleName());
                    }
                    p.setUniqueItems(pi.isUniqueItems());
                    rep.getProperties().add(p);
                }
                rep.setRaw(ri.isRaw() || ReflectUtils.isJdkClass(ri.getType()));
                contract.getRepresentations().add(rep);
            }
        }
        Collections.sort(result.getContract().getRepresentations(), new Comparator<Representation>(){

            @Override
            public int compare(Representation o1, Representation o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(result.getContract().getResources(), new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o1.getResourcePath().compareTo(o2.getResourcePath());
            }
        });
        return result;
    }

    private static String toString(List<DocumentationInfo> dis) {
        return Introspector.toString(dis, "");
    }

    private static String toString(List<DocumentationInfo> dis, String defaultValue) {
        if (dis != null && !dis.isEmpty()) {
            StringBuilder d = new StringBuilder();
            for (DocumentationInfo doc : dis) {
                if (doc.getTextContent() == null) continue;
                d.append(doc.getTextContent());
            }
            if (d.length() > 0) {
                return d.toString();
            }
        }
        return defaultValue;
    }

    public Introspector(Application application, boolean verbose) {
        this(null, application);
    }

    public Introspector(Component component, Application application) {
        this.definition = Introspector.toDefinition(Introspector.getApplicationInfo(application, null));
        if (component != null && this.definition != null) {
            LOGGER.fine("Look for the endpoint.");
            String endpoint = null;
            endpoint = this.getEndpoint(component.getDefaultHost(), application);
            for (int i = 0; endpoint == null && i < component.getHosts().size(); ++i) {
                VirtualHost virtualHost = (VirtualHost)component.getHosts().get(i);
                endpoint = this.getEndpoint(virtualHost, application);
            }
            this.definition.setEndpoint(endpoint);
        }
    }

    public Definition getDefinition() {
        return this.definition;
    }

    private String getEndpoint(VirtualHost virtualHost, Application application) {
        String result = null;
        for (Route route : virtualHost.getRoutes()) {
            Application app;
            if (route.getNext() == null || (app = Introspector.getNextApplication(route.getNext())) == null || !application.getClass().equals(app.getClass())) continue;
            String hostDomain = null;
            if (virtualHost.getHostDomain() != null && !".*".equals(virtualHost.getHostDomain())) {
                hostDomain = virtualHost.getHostDomain().contains("|") ? virtualHost.getHostDomain().split("|")[0] : virtualHost.getHostDomain();
            }
            if (hostDomain == null) continue;
            Protocol scheme = null;
            if (!".*".equals(virtualHost.getHostScheme())) {
                scheme = Protocol.valueOf((String)virtualHost.getHostScheme());
            }
            if (scheme == null) {
                scheme = Protocol.HTTP;
            }
            Reference ref = new Reference();
            ref.setProtocol(scheme);
            ref.setHostDomain(hostDomain);
            if (route instanceof TemplateRoute) {
                ref.addSegment(((TemplateRoute)route).getTemplate().getPattern());
            }
            try {
                ref.setHostPort(Integer.valueOf(Integer.parseInt(virtualHost.getHostPort())));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = ref.toString();
        }
        return result;
    }
}

