/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.raml;

import org.raml.emitter.RamlEmitter;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.raml.RamlTranslator;
import org.restlet.ext.apispark.internal.introspection.application.ApplicationIntrospector;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.Router;

public class RamlSpecificationRestlet
extends Restlet {
    private Restlet apiInboundRoot;
    private String apiVersion;
    private Application application;
    private String basePath;
    private Reference baseRef;
    private Definition definition;
    private String ramlVersion = "0.8";

    public RamlSpecificationRestlet() {
        this(null);
    }

    public RamlSpecificationRestlet(Context context) {
        super(context);
    }

    public void attach(Router router) {
        this.attach(router, "/raml");
    }

    public void attach(Router router, String path) {
        router.attach(path, (Restlet)this);
    }

    public Restlet getApiInboundRoot() {
        if (this.apiInboundRoot == null && this.application != null) {
            this.apiInboundRoot = this.application.getInboundRoot();
        }
        return this.apiInboundRoot;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Definition getDefinition() {
        if (this.definition != null) return this.definition;
        Class<RamlSpecificationRestlet> clazz = RamlSpecificationRestlet.class;
        synchronized (RamlSpecificationRestlet.class) {
            this.definition = ApplicationIntrospector.getDefinition((Application)this.application, (Reference)this.baseRef, null, (boolean)false);
            if (this.definition.getVersion() != null) return this.definition;
            this.definition.setVersion("1.0");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.definition;
        }
    }

    public Representation getRaml() {
        return new StringRepresentation((CharSequence)new RamlEmitter().dump(RamlTranslator.getRaml((Definition)this.getDefinition())), MediaType.TEXT_PLAIN);
    }

    public String getRamlVersion() {
        return this.ramlVersion;
    }

    public void handle(Request request, Response response) {
        if (Method.GET.equals((Object)request.getMethod())) {
            response.setEntity(this.getRaml());
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
    }

    public void setApiInboundRoot(Application application) {
        this.application = application;
    }

    public void setApiInboundRoot(Restlet apiInboundRoot) {
        this.apiInboundRoot = apiInboundRoot;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.baseRef = basePath != null ? new Reference(basePath) : null;
    }

    public void setRamlVersion(String ramlVersion) {
        this.ramlVersion = ramlVersion;
    }
}

