/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.rdf.internal.xml.ScopedProperty;
import org.restlet.representation.Representation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ContentReader
extends DefaultHandler {
    private static int blankNodeId = 0;
    private ScopedProperty<Reference> base;
    private StringBuilder builder;
    private boolean consumingContent;
    private String currentDataType;
    private Object currentObject;
    private Reference currentPredicate;
    private GraphHandler graphHandler;
    private ScopedProperty<Language> language;
    private int nodeDepth;
    private Map<String, String> prefixes;
    private boolean rdfDefaultNamespace;
    private Reference reifiedRef;
    private List<State> states;
    private List<Reference> subjects;

    private static String newBlankNodeId() {
        return "#_bn" + blankNodeId++;
    }

    public ContentReader(Representation representation, GraphHandler graphHandler) {
        this.graphHandler = graphHandler;
        this.base = new ScopedProperty();
        this.language = new ScopedProperty();
        if (representation.getLocationRef() != null) {
            this.base.add(representation.getLocationRef().getTargetRef());
            this.base.incrDepth();
        }
        if (representation.getLanguages().size() == 1) {
            this.language.add((Language)representation.getLanguages().get(1));
            this.language.incrDepth();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.consumingContent) {
            this.builder.append(ch, start, length);
        }
    }

    private boolean checkRdfQName(String localName, String qName) {
        boolean result = qName.equals("rdf:" + localName);
        if (!result) {
            int index = qName.indexOf(":");
            result = this.rdfDefaultNamespace && index == -1 && localName.equals(qName);
        }
        return result;
    }

    @Override
    public void endDocument() throws SAXException {
        this.builder = null;
        this.currentObject = null;
        this.currentPredicate = null;
        this.graphHandler = null;
        this.prefixes.clear();
        this.prefixes = null;
        this.states.clear();
        this.states = null;
        this.subjects.clear();
        this.subjects = null;
        this.nodeDepth = 0;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        State state = this.popState();
        if (state == State.SUBJECT) {
            this.popSubject();
        } else if (state == State.PREDICATE) {
            if (this.consumingContent) {
                this.link(this.getCurrentSubject(), this.currentPredicate, this.getLiteral(this.builder.toString(), null, this.language.getValue()));
                this.consumingContent = false;
            }
        } else if (state != State.OBJECT && state == State.LITERAL) {
            if (this.nodeDepth == 0) {
                this.link(this.getCurrentSubject(), this.currentPredicate, this.getLiteral(this.builder.toString(), this.currentDataType, this.language.getValue()));
            } else {
                this.builder.append("</");
                if (uri != null && !"".equals(uri)) {
                    this.builder.append(uri).append(":");
                }
                this.builder.append(localName).append(">");
                --this.nodeDepth;
                this.pushState(state);
            }
        }
        this.base.decrDepth();
        this.language.decrDepth();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixes.remove(prefix);
    }

    private State getCurrentState() {
        State result = null;
        int size = this.states.size();
        if (size > 0) {
            result = this.states.get(size - 1);
        }
        return result;
    }

    private Reference getCurrentSubject() {
        Reference result = null;
        int size = this.subjects.size();
        if (size > 0) {
            result = this.subjects.get(size - 1);
        }
        return result;
    }

    private Literal getLiteral(String value, String datatype, Language language) {
        Literal literal = new Literal(value);
        if (datatype != null) {
            literal.setDatatypeRef(new Reference(datatype));
        }
        if (language != null) {
            literal.setLanguage(language);
        }
        return literal;
    }

    private void link() {
        Reference currentSubject = this.getCurrentSubject();
        if (currentSubject != null) {
            if (this.currentObject instanceof Reference) {
                this.link(currentSubject, this.currentPredicate, (Reference)this.currentObject);
            } else if (this.currentObject instanceof Literal) {
                this.link(currentSubject, this.currentPredicate, (Literal)this.currentObject);
            } else {
                Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
            }
        } else {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the subject is not a Reference.");
        }
    }

    private void link(Reference subject, Reference predicate, Literal object) {
        this.graphHandler.link(subject, predicate, object);
        if (this.reifiedRef != null) {
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_SUBJECT, subject);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_PREDICATE, predicate);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_OBJECT, object);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_TYPE, RdfConstants.PREDICATE_STATEMENT);
            this.reifiedRef = null;
        }
    }

    private void link(Reference subject, Reference predicate, Reference object) {
        this.graphHandler.link(subject, predicate, object);
        if (this.reifiedRef != null) {
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_SUBJECT, subject);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_PREDICATE, predicate);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_OBJECT, object);
            this.graphHandler.link(this.reifiedRef, RdfConstants.PREDICATE_TYPE, RdfConstants.PREDICATE_STATEMENT);
            this.reifiedRef = null;
        }
    }

    private Reference parseNode(String uri, String localName, String name, Attributes attributes) {
        Reference result = null;
        ArrayList<String[]> arcs = new ArrayList<String[]>();
        boolean found = false;
        if (attributes.getIndex("xml:base") != -1) {
            this.base.add(new Reference(attributes.getValue("xml:base")));
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            if (this.checkRdfQName("about", qName)) {
                found = true;
                result = this.resolve(attributes.getValue(i), false);
                continue;
            }
            if (this.checkRdfQName("nodeID", qName)) {
                found = true;
                result = Link.createBlankRef(attributes.getValue(i));
                continue;
            }
            if (this.checkRdfQName("ID", qName)) {
                found = true;
                result = this.resolve(attributes.getValue(i), true);
                continue;
            }
            if ("xml:lang".equals(qName)) {
                this.language.add(Language.valueOf((String)attributes.getValue(i)));
                continue;
            }
            if ("xml:base".equals(qName) || qName.startsWith("xmlns")) continue;
            String[] arc = new String[]{qName, attributes.getValue(i)};
            arcs.add(arc);
        }
        if (!found) {
            result = Link.createBlankRef(ContentReader.newBlankNodeId());
        }
        if (!this.checkRdfQName("Description", name)) {
            this.graphHandler.link(result, RdfConstants.PREDICATE_TYPE, this.resolve(uri, name));
        }
        for (String[] arc : arcs) {
            this.graphHandler.link(result, this.resolve(null, arc[0]), this.getLiteral(arc[1], null, this.language.getValue()));
        }
        return result;
    }

    private State popState() {
        State result = null;
        int size = this.states.size();
        if (size > 0) {
            result = this.states.remove(size - 1);
        }
        return result;
    }

    private Reference popSubject() {
        Reference result = null;
        int size = this.subjects.size();
        if (size > 0) {
            result = this.subjects.remove(size - 1);
        }
        return result;
    }

    private void pushState(State state) {
        this.states.add(state);
    }

    private void pushSubject(Reference subject) {
        this.subjects.add(subject);
    }

    private Reference resolve(String value, boolean fragment) {
        Reference result = null;
        if (fragment) {
            result = new Reference(this.base.getValue());
            result.setFragment(value);
        } else {
            result = new Reference(value);
            if (result.isRelative()) {
                result = new Reference(this.base.getValue(), value);
            }
        }
        return result.getTargetRef();
    }

    private Reference resolve(String uri, String qName) {
        Reference result = null;
        int index = qName.indexOf(":");
        String prefix = null;
        String localName = null;
        if (index != -1) {
            prefix = qName.substring(0, index);
            localName = qName.substring(index + 1);
        } else {
            localName = qName;
            prefix = "";
        }
        if (uri != null && !"".equals(uri)) {
            result = !uri.endsWith("#") && !uri.endsWith("/") ? new Reference(uri + "/" + localName) : new Reference(uri + localName);
        } else {
            String baseUri = this.prefixes.get(prefix);
            if (baseUri != null) {
                result = new Reference(baseUri + localName);
            }
        }
        return result == null ? null : result.getTargetRef();
    }

    @Override
    public void startDocument() throws SAXException {
        this.prefixes = new HashMap<String, String>();
        this.builder = new StringBuilder();
        this.states = new ArrayList<State>();
        this.subjects = new ArrayList<Reference>();
        this.nodeDepth = 0;
        this.pushState(State.NONE);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        State state = this.getCurrentState();
        this.base.incrDepth();
        this.language.incrDepth();
        if (!this.consumingContent && this.builder != null) {
            this.builder = null;
        }
        if (state == State.NONE) {
            if (this.checkRdfQName("RDF", name)) {
                String base = attributes.getValue("xml:base");
                if (base != null) {
                    this.base.add(new Reference(base));
                }
            } else {
                this.pushSubject(this.parseNode(uri, localName, name, attributes));
                this.pushState(State.SUBJECT);
            }
        } else if (state == State.SUBJECT) {
            ArrayList<String[]> arcs = new ArrayList<String[]>();
            this.pushState(State.PREDICATE);
            this.consumingContent = true;
            Reference currentSubject = this.getCurrentSubject();
            this.currentPredicate = this.resolve(uri, name);
            Reference currentObject = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qName = attributes.getQName(i);
                if (this.checkRdfQName("resource", qName)) {
                    this.consumingContent = false;
                    currentObject = this.resolve(attributes.getValue(i), false);
                    this.popState();
                    this.pushState(State.OBJECT);
                    continue;
                }
                if (this.checkRdfQName("datatype", qName)) {
                    this.consumingContent = true;
                    this.popState();
                    this.pushState(State.LITERAL);
                    this.currentDataType = attributes.getValue(i);
                    continue;
                }
                if (this.checkRdfQName("parseType", qName)) {
                    String value = attributes.getValue(i);
                    if ("Literal".equals(value)) {
                        this.consumingContent = true;
                        this.popState();
                        this.pushState(State.LITERAL);
                        this.currentDataType = RdfConstants.RDF_SYNTAX + "XMLLiteral";
                        this.nodeDepth = 0;
                        continue;
                    }
                    if ("Resource".equals(value)) {
                        this.consumingContent = false;
                        currentObject = Link.createBlankRef(ContentReader.newBlankNodeId());
                        this.popState();
                        this.pushState(State.SUBJECT);
                        this.pushSubject(currentObject);
                        continue;
                    }
                    this.consumingContent = false;
                    continue;
                }
                if (this.checkRdfQName("nodeID", qName)) {
                    this.consumingContent = false;
                    currentObject = Link.createBlankRef(attributes.getValue(i));
                    this.popState();
                    this.pushState(State.SUBJECT);
                    this.pushSubject(currentObject);
                    continue;
                }
                if (this.checkRdfQName("ID", qName)) {
                    this.reifiedRef = this.resolve(attributes.getValue(i), true);
                    continue;
                }
                if ("xml:lang".equals(qName)) {
                    this.language.add(Language.valueOf((String)attributes.getValue(i)));
                    continue;
                }
                if (qName.startsWith("xmlns")) continue;
                String[] arc = new String[]{qName, attributes.getValue(i)};
                arcs.add(arc);
            }
            if (currentObject != null) {
                this.link(currentSubject, this.currentPredicate, currentObject);
            }
            if (!arcs.isEmpty()) {
                boolean found = false;
                Reference blankNode = Link.createBlankRef(ContentReader.newBlankNodeId());
                for (String[] arc : arcs) {
                    Reference pRef = this.resolve(null, arc[0]);
                    if (pRef == null) continue;
                    found = true;
                    this.graphHandler.link(blankNode, pRef, new Literal(arc[1]));
                }
                if (found) {
                    this.link(currentSubject, this.currentPredicate, blankNode);
                    this.popState();
                    this.pushState(State.OBJECT);
                }
            }
            if (this.consumingContent) {
                this.builder = new StringBuilder();
            }
        } else if (state == State.PREDICATE) {
            this.consumingContent = false;
            Reference object = this.parseNode(uri, localName, name, attributes);
            this.currentObject = object;
            this.link();
            this.pushSubject(object);
            this.pushState(State.SUBJECT);
        } else if (state != State.OBJECT && state == State.LITERAL) {
            ++this.nodeDepth;
            this.builder.append("<");
            if (uri != null && !"".equals(uri)) {
                this.builder.append(uri).append(":");
            }
            this.builder.append(localName).append(">");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        boolean bl = this.rdfDefaultNamespace = this.rdfDefaultNamespace || prefix == null || "".equals(prefix) && RdfConstants.RDF_SYNTAX.toString(true, true).equals(uri);
        if (!uri.endsWith("#") && !uri.endsWith("/")) {
            this.prefixes.put(prefix, uri + "/");
        } else {
            this.prefixes.put(prefix, uri);
        }
    }

    public static enum State {
        LITERAL,
        NONE,
        OBJECT,
        PREDICATE,
        SUBJECT;

    }
}

