/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import org.restlet.Server;
import org.restlet.engine.adapter.HttpServerHelper;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.connect.Connection;

public abstract class SimpleServerHelper
extends HttpServerHelper {
    private volatile InetSocketAddress address;
    private volatile boolean confidential;
    private volatile Connection connection;
    private volatile ContainerServer containerServer;

    public SimpleServerHelper(Server server) {
        super(server);
    }

    protected InetSocketAddress getAddress() {
        return this.address;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected ContainerServer getContainerServer() {
        return this.containerServer;
    }

    public int getDefaultThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("defaultThreads", "5"));
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    protected void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    protected void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected void setContainerServer(ContainerServer container) {
        this.containerServer = container;
    }

    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the Simple " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
    }

    public synchronized void stop() throws Exception {
        this.getLogger().info("Stopping the Simple server");
        try {
            this.getConnection().close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Exception while closing the server socket. Can probably be safely ignored.", e);
        }
        if (this.getContainerServer() != null) {
            this.getContainerServer().stop();
        }
    }
}

