/**
 * Copyright 2005-2014 Restlet
 * 
 * The contents of this file are subject to the terms of one of the following
 * open source licenses: Apache 2.0 or LGPL 3.0 or LGPL 2.1 or CDDL 1.0 or EPL
 * 1.0 (the "Licenses"). You can select the license that you prefer but you may
 * not use this file except in compliance with one of these Licenses.
 * 
 * You can obtain a copy of the Apache 2.0 license at
 * http://www.opensource.org/licenses/apache-2.0
 * 
 * You can obtain a copy of the LGPL 3.0 license at
 * http://www.opensource.org/licenses/lgpl-3.0
 * 
 * You can obtain a copy of the LGPL 2.1 license at
 * http://www.opensource.org/licenses/lgpl-2.1
 * 
 * You can obtain a copy of the CDDL 1.0 license at
 * http://www.opensource.org/licenses/cddl1
 * 
 * You can obtain a copy of the EPL 1.0 license at
 * http://www.opensource.org/licenses/eclipse-1.0
 * 
 * See the Licenses for the specific language governing permissions and
 * limitations under the Licenses.
 * 
 * Alternatively, you can obtain a royalty free commercial license with less
 * limitations, transferable or non-transferable, directly at
 * http://restlet.com/products/restlet-framework
 * 
 * Restlet is a registered trademark of Restlet S.A.S.
 */

package org.restlet.ext.sip.internal;

/**
 * Constants related to the SIP protocol.
 * 
 * @author Jerome Louvel
 */
public final class SipConstants {

    // ---------------------
    // --- Header names ---
    // ---------------------

    public static final String HEADER_ALERT_INFO = "Alert-Info";

    public static final String HEADER_ALLOW_EVENTS = "Allow-Events";

    public static final String HEADER_CALL_ID = "Call-ID";

    public static final String HEADER_CALL_INFO = "Call-Info";

    public static final String HEADER_CALL_SEQ = "CSeq";

    public static final String HEADER_CONTACT = "Contact";

    public static final String HEADER_ENCRYPTION = "Encryption";

    public static final String HEADER_ERROR_INFO = "Error-Info";

    public static final String HEADER_EVENT = "Event";

    public static final String HEADER_IN_REPLY_TO = "In-Reply-To";

    public static final String HEADER_MIME_VERSION = "MIME-Version";

    public static final String HEADER_MIN_EXPIRES = "Min-Expires";

    public static final String HEADER_ORGANIZATION = "Organization";

    public static final String HEADER_PRIORITY = "Priority";

    public static final String HEADER_PROXY_REQUIRE = "Proxy-Require";

    public static final String HEADER_RECORD_ROUTE = "Record-Route";

    public static final String HEADER_REFER_TO = "Refer-To";

    public static final String HEADER_REPLY_TO = "Reply-To";

    public static final String HEADER_REQUIRE = "Require";

    public static final String HEADER_RETRY_AFTER = "Retry-After";

    public static final String HEADER_ROUTE = "Route";

    public static final String HEADER_RSEQ = "RSeq";

    public static final String HEADER_SERVER = "Server";

    public static final String HEADER_SIP_ETAG = "SIP-ETag";

    public static final String HEADER_SIP_IF_MATCH = "SIP-If-Match";

    public static final String HEADER_SUBJECT = "Subject";

    public static final String HEADER_SUBSCRIPTION_STATE = "Subscription-State";

    public static final String HEADER_SUPPORTED = "Supported";

    public static final String HEADER_TO = "To";

    public static final String HEADER_UNSUPPORTED = "Unsupported";
}
