/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.RecipientInfo;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.engine.header.CacheDirectiveReader;
import org.restlet.engine.header.CookieReader;
import org.restlet.engine.header.ExpectationReader;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.PreferenceReader;
import org.restlet.engine.header.RangeReader;
import org.restlet.engine.header.RecipientInfoReader;
import org.restlet.engine.header.WarningReader;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.request.InboundRequest;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.ContactInfo;
import org.restlet.ext.sip.Event;
import org.restlet.ext.sip.EventType;
import org.restlet.ext.sip.OptionTag;
import org.restlet.ext.sip.Priority;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.SipRequest;
import org.restlet.ext.sip.Subscription;
import org.restlet.ext.sip.internal.AddressReader;
import org.restlet.ext.sip.internal.ContactInfoReader;
import org.restlet.ext.sip.internal.EventReader;
import org.restlet.ext.sip.internal.EventTypeReader;
import org.restlet.ext.sip.internal.OptionTagReader;
import org.restlet.ext.sip.internal.SipRecipientInfoReader;
import org.restlet.ext.sip.internal.SubscriptionReader;
import org.restlet.util.Series;

public class SipInboundRequest
extends SipRequest
implements InboundRequest {
    private volatile boolean cacheDirectivesAdded;
    private volatile boolean clientAdded;
    private volatile boolean conditionAdded;
    private final Connection<Server> connection;
    private final Context context;
    private volatile boolean cookiesAdded;
    private volatile String protocol;
    private volatile boolean proxySecurityAdded;
    private volatile boolean rangesAdded;
    private volatile boolean recipientsInfoAdded;
    private volatile boolean referrerAdded;
    private volatile String resourceUri;
    private volatile boolean securityAdded;
    private final Principal userPrincipal;
    private volatile boolean warningsAdded;
    private volatile boolean alertInfoAdded;
    private volatile boolean allowedEventTypesAdded;
    private volatile boolean callerInfoAdded;
    private volatile boolean contactAdded;
    private volatile boolean eventAdded;
    private volatile boolean inReplyToAdded;
    private volatile boolean priorityAdded;
    private volatile boolean proxyRequiresAdded;
    private volatile boolean sipRecipientsInfoAdded;
    private volatile boolean recordedRoutesAdded;
    private volatile boolean referToAdded;
    private volatile boolean replyToAdded;
    private volatile boolean requiresAdded;
    private volatile boolean routesAdded;
    private volatile boolean sipIfMatchAdded;
    private volatile boolean subscriptionAdded;
    private volatile boolean supportedAdded;

    public SipInboundRequest(Context context, Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        this.context = context;
        this.cacheDirectivesAdded = false;
        this.clientAdded = false;
        this.conditionAdded = false;
        this.connection = connection;
        this.cookiesAdded = false;
        this.referrerAdded = false;
        this.securityAdded = false;
        this.userPrincipal = null;
        this.proxySecurityAdded = false;
        this.recipientsInfoAdded = false;
        this.resourceUri = resourceUri;
        this.protocol = protocol;
        this.warningsAdded = false;
        this.alertInfoAdded = false;
        this.allowedEventTypesAdded = false;
        this.callerInfoAdded = false;
        this.contactAdded = false;
        this.eventAdded = false;
        this.inReplyToAdded = false;
        this.priorityAdded = false;
        this.setMethod(Method.valueOf((String)methodName));
    }

    public SipInboundRequest(SipInboundRequest request) {
        super(request);
        this.connection = request.getConnection();
        this.context = request.context;
        this.userPrincipal = request.getUserPrincipal();
    }

    public boolean abort() {
        this.getConnection().close(false);
        return true;
    }

    public synchronized void commit(Response response) {
        if (response != null && !response.isCommitted()) {
            this.getConnection().commit(response);
            response.setCommitted(true);
        }
    }

    @Override
    public Address getAlertInfo() {
        if (!this.alertInfoAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Alert-Info");
            if (header != null) {
                try {
                    this.setAlertInfo(new AddressReader(header).readValue());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.alertInfoAdded = true;
        }
        return super.getAlertInfo();
    }

    @Override
    public List<EventType> getAllowedEventTypes() {
        List<EventType> aet = super.getAllowedEventTypes();
        if (!this.allowedEventTypesAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Allow-Events");
            if (header != null) {
                try {
                    aet.addAll(new EventTypeReader(header).readValues());
                    this.allowedEventTypesAdded = true;
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.allowedEventTypesAdded = true;
        }
        return aet;
    }

    public List<CacheDirective> getCacheDirectives() {
        List result = super.getCacheDirectives();
        if (!this.cacheDirectivesAdded) {
            if (this.getHeaders() != null) {
                for (Header header : this.getHeaders().subList("Cache-Control")) {
                    CacheDirectiveReader.addValues((Header)header, (Collection)result);
                }
            }
            this.cacheDirectivesAdded = true;
        }
        return result;
    }

    @Override
    public List<Address> getCallerInfo() {
        List<Address> ci = super.getCallerInfo();
        if (!this.callerInfoAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Call-Info");
            if (header != null) {
                try {
                    ci.addAll(new AddressReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.callerInfoAdded = true;
        }
        return ci;
    }

    public ChallengeResponse getChallengeResponse() {
        ChallengeResponse result = super.getChallengeResponse();
        if (!this.securityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Authorization");
                result = AuthenticatorUtils.parseResponse((Request)this, (String)authorization, (Series)this.getHeaders());
                this.setChallengeResponse(result);
            }
            this.securityAdded = true;
        }
        return result;
    }

    public ClientInfo getClientInfo() {
        ClientInfo result = super.getClientInfo();
        if (!this.clientAdded) {
            if (this.getHeaders() != null) {
                String header;
                boolean useForwardedForHeader;
                String acceptMediaType = this.getHeaders().getValues("Accept");
                String acceptCharset = this.getHeaders().getValues("Accept-Charset");
                String acceptEncoding = this.getHeaders().getValues("Accept-Encoding");
                String acceptLanguage = this.getHeaders().getValues("Accept-Language");
                String acceptPatch = this.getHeaders().getValues("Accept-Patch");
                String expect = this.getHeaders().getValues("Expect");
                try {
                    PreferenceReader.addCharacterSets((String)acceptCharset, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addEncodings((String)acceptEncoding, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addLanguages((String)acceptLanguage, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addMediaTypes((String)acceptMediaType, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addPatches((String)acceptPatch, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    ExpectationReader.addValues((String)expect, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                result.setAgent(this.getHeaders().getValues("User-Agent"));
                result.setFrom(this.getHeaders().getFirstValue("From", true));
                result.setAddress(this.getConnection().getAddress());
                result.setPort(this.getConnection().getPort());
                if (this.userPrincipal != null) {
                    result.getPrincipals().add(this.userPrincipal);
                }
                if (this.context != null && (useForwardedForHeader = Boolean.parseBoolean(this.context.getParameters().getFirstValue("useForwardedForHeader", false))) && (header = this.getHeaders().getValues("X-Forwarded-For")) != null) {
                    String[] addresses = header.split(",");
                    for (int i = 0; i < addresses.length; ++i) {
                        String address = addresses[i].trim();
                        result.getForwardedAddresses().add(address);
                    }
                }
            }
            this.clientAdded = true;
        }
        return result;
    }

    public Conditions getConditions() {
        Conditions result = super.getConditions();
        if (!this.conditionAdded) {
            if (this.getHeaders() != null) {
                String ifMatchHeader = this.getHeaders().getValues("If-Match");
                String ifNoneMatchHeader = this.getHeaders().getValues("If-None-Match");
                Date ifModifiedSince = null;
                Date ifUnmodifiedSince = null;
                String ifRangeHeader = this.getHeaders().getFirstValue("If-Range", true);
                for (Header header : this.getHeaders()) {
                    if (header.getName().equalsIgnoreCase("If-Modified-Since")) {
                        ifModifiedSince = HeaderReader.readDate((String)header.getValue(), (boolean)false);
                        continue;
                    }
                    if (!header.getName().equalsIgnoreCase("If-Unmodified-Since")) continue;
                    ifUnmodifiedSince = HeaderReader.readDate((String)header.getValue(), (boolean)false);
                }
                if (ifModifiedSince != null && ifModifiedSince.getTime() != -1L) {
                    result.setModifiedSince(ifModifiedSince);
                }
                if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() != -1L) {
                    result.setUnmodifiedSince(ifUnmodifiedSince);
                }
                ArrayList<Tag> match = null;
                Tag current = null;
                if (ifMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifMatchHeader);
                        String value = hr.readRawValue();
                        while (value != null) {
                            current = Tag.parse((String)value);
                            if (match == null) {
                                match = new ArrayList<Tag>();
                                result.setMatch(match);
                            }
                            match.add(current);
                            value = hr.readRawValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-match header: " + ifMatchHeader);
                    }
                }
                ArrayList<Tag> noneMatch = null;
                if (ifNoneMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifNoneMatchHeader);
                        String value = hr.readRawValue();
                        while (value != null) {
                            current = Tag.parse((String)value);
                            if (noneMatch == null) {
                                noneMatch = new ArrayList<Tag>();
                                result.setNoneMatch(noneMatch);
                            }
                            noneMatch.add(current);
                            value = hr.readRawValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-none-match header: " + ifNoneMatchHeader);
                    }
                }
                if (ifRangeHeader != null && ifRangeHeader.length() > 0) {
                    Tag tag = Tag.parse((String)ifRangeHeader);
                    if (tag != null) {
                        result.setRangeTag(tag);
                    } else {
                        Date date = HeaderReader.readDate((String)ifRangeHeader, (boolean)false);
                        result.setRangeDate(date);
                    }
                }
            }
            this.conditionAdded = true;
        }
        return result;
    }

    public Connection<Server> getConnection() {
        return this.connection;
    }

    @Override
    public List<ContactInfo> getContacts() {
        List<ContactInfo> c = super.getContacts();
        if (!this.contactAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Contact");
            if (header != null) {
                try {
                    c.addAll(new ContactInfoReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.contactAdded = true;
        }
        return c;
    }

    public Series<Cookie> getCookies() {
        Series result = super.getCookies();
        if (!this.cookiesAdded) {
            String cookieValues;
            if (this.getHeaders() != null && (cookieValues = this.getHeaders().getValues("Cookie")) != null) {
                new CookieReader(cookieValues).addValues((Collection)result);
            }
            this.cookiesAdded = true;
        }
        return result;
    }

    @Override
    public Event getEvent() {
        if (!this.eventAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Event");
            if (header != null) {
                try {
                    this.setEvent(new EventReader(header).readValue());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.eventAdded = true;
        }
        return super.getEvent();
    }

    @Override
    public List<String> getInReplyTo() {
        List<String> irt = super.getInReplyTo();
        if (!this.inReplyToAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Allow-Events");
            if (header != null) {
                try {
                    irt.addAll(new HeaderReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.inReplyToAdded = true;
        }
        return irt;
    }

    @Override
    public Priority getPriority() {
        if (!this.priorityAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Priority");
            if (header != null) {
                try {
                    this.setPriority(Priority.valueOf(header));
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.priorityAdded = true;
        }
        return super.getPriority();
    }

    public ChallengeResponse getProxyChallengeResponse() {
        ChallengeResponse result = super.getProxyChallengeResponse();
        if (!this.proxySecurityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Proxy-Authorization");
                result = AuthenticatorUtils.parseResponse((Request)this, (String)authorization, (Series)this.getHeaders());
                this.setProxyChallengeResponse(result);
            }
            this.proxySecurityAdded = true;
        }
        return result;
    }

    @Override
    public List<OptionTag> getProxyRequires() {
        List<OptionTag> pr = super.getProxyRequires();
        if (!this.proxyRequiresAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Proxy-Require");
            if (header != null) {
                try {
                    pr.addAll(new OptionTagReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.proxyRequiresAdded = true;
        }
        return pr;
    }

    public List<Range> getRanges() {
        List result = super.getRanges();
        if (!this.rangesAdded) {
            if (this.getHeaders() != null) {
                String ranges = this.getHeaders().getValues("Range");
                result.addAll(RangeReader.read((String)ranges));
            }
            this.rangesAdded = true;
        }
        return result;
    }

    public List<RecipientInfo> getRecipientsInfo() {
        List result = super.getRecipientsInfo();
        if (!this.recipientsInfoAdded && this.getHeaders() != null) {
            for (String header : this.getHeaders().getValuesArray("Via", true)) {
                new RecipientInfoReader(header).addValues((Collection)result);
            }
            this.setRecipientsInfo(result);
        }
        return result;
    }

    @Override
    public List<Address> getRecordedRoutes() {
        List<Address> rr = super.getRecordedRoutes();
        if (!this.recordedRoutesAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Record-Route");
            if (header != null) {
                try {
                    rr.addAll(new AddressReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.recordedRoutesAdded = true;
        }
        return rr;
    }

    public Reference getReferrerRef() {
        if (!this.referrerAdded) {
            String referrerValue;
            if (this.getHeaders() != null && (referrerValue = this.getHeaders().getValues("Referer")) != null) {
                this.setReferrerRef(new Reference(referrerValue));
            }
            this.referrerAdded = true;
        }
        return super.getReferrerRef();
    }

    @Override
    public Address getReferTo() {
        if (!this.referToAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Refer-To");
            if (header != null) {
                try {
                    this.setReferTo(new AddressReader(header).readValue());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.referToAdded = true;
        }
        return super.getReferTo();
    }

    @Override
    public Address getReplyTo() {
        if (!this.replyToAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Reply-To");
            if (header != null) {
                try {
                    this.setReplyTo(new AddressReader(header).readValue());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.replyToAdded = true;
        }
        return super.getReplyTo();
    }

    @Override
    public List<OptionTag> getRequires() {
        List<OptionTag> r = super.getRequires();
        if (!this.requiresAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Require");
            if (header != null) {
                try {
                    r.addAll(new OptionTagReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.requiresAdded = true;
        }
        return r;
    }

    @Override
    public List<Address> getRoutes() {
        List<Address> r = super.getRoutes();
        if (!this.routesAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Route");
            if (header != null) {
                try {
                    r.addAll(new AddressReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.routesAdded = true;
        }
        return r;
    }

    @Override
    public Tag getSipIfMatch() {
        if (!this.sipIfMatchAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("SIP-If-Match");
            if (header != null) {
                try {
                    this.setSipIfMatch(Tag.parse((String)header));
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.sipIfMatchAdded = true;
        }
        return super.getSipIfMatch();
    }

    @Override
    public List<SipRecipientInfo> getSipRecipientsInfo() {
        List<SipRecipientInfo> sri = super.getSipRecipientsInfo();
        if (!this.sipRecipientsInfoAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Via");
            if (header != null) {
                try {
                    sri.addAll(new SipRecipientInfoReader(header).readValues());
                    this.sipRecipientsInfoAdded = true;
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.sipRecipientsInfoAdded = true;
        }
        return sri;
    }

    @Override
    public Subscription getSubscriptionState() {
        if (!this.subscriptionAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Subscription-State");
            if (header != null) {
                try {
                    this.setSubscriptionState(new SubscriptionReader(header).readValue());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.subscriptionAdded = true;
        }
        return super.getSubscriptionState();
    }

    @Override
    public List<OptionTag> getSupported() {
        List<OptionTag> s = super.getSupported();
        if (!this.supportedAdded) {
            String header;
            String string = header = this.getHeaders() == null ? null : this.getHeaders().getValues("Supported");
            if (header != null) {
                try {
                    s.addAll(new OptionTagReader(header).readValues());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().info(e.getMessage());
                }
            }
            this.supportedAdded = true;
        }
        return s;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public List<Warning> getWarnings() {
        List result = super.getWarnings();
        if (!this.warningsAdded) {
            if (this.getHeaders() != null) {
                for (String warning : this.getHeaders().getValuesArray("Warning", true)) {
                    new WarningReader(warning).addValues((Collection)result);
                }
            }
            this.warningsAdded = true;
        }
        return result;
    }

    @Override
    public void setAlertInfo(Address alertInfo) {
        super.setAlertInfo(alertInfo);
        this.alertInfoAdded = true;
    }

    @Override
    public void setAllowedEventTypes(List<EventType> allowedEventTypes) {
        super.setAllowedEventTypes(allowedEventTypes);
        this.allowedEventTypesAdded = true;
    }

    @Override
    public void setCallerInfo(List<Address> callerInfo) {
        super.setCallerInfo(callerInfo);
        this.callerInfoAdded = true;
    }

    public void setChallengeResponse(ChallengeResponse response) {
        super.setChallengeResponse(response);
        this.securityAdded = true;
    }

    @Override
    public void setContacts(List<ContactInfo> contact) {
        super.setContacts(contact);
        this.contactAdded = true;
    }

    @Override
    public void setEvent(Event event) {
        super.setEvent(event);
        this.eventAdded = true;
    }

    public void setHeaders(Series<Header> headers) {
        String fromHeader;
        String toHeader;
        String callSeqHeader;
        String callIdHeader;
        String maxForwardsHeader;
        this.getAttributes().put("org.restlet.http.headers", headers);
        if (this.protocol != null) {
            int slashIndex = this.protocol.indexOf(47);
            this.protocol = slashIndex != -1 ? this.protocol.substring(slashIndex + 1) : null;
        }
        Protocol serverProtocol = (Protocol)((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        this.setProtocol(new Protocol(serverProtocol.getSchemeName(), serverProtocol.getName(), serverProtocol.getDescription(), serverProtocol.getDefaultPort(), serverProtocol.isConfidential(), this.protocol));
        String host = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Host", true);
        String hostDomain = null;
        int hostPort = -1;
        if (host != null) {
            int colonIndex = host.indexOf(58);
            if (colonIndex != -1) {
                hostDomain = host.substring(0, colonIndex);
                hostPort = Integer.valueOf(host.substring(colonIndex + 1));
            } else {
                hostDomain = host;
                hostPort = this.getProtocol().getDefaultPort();
            }
        } else if (!Protocol.SIP.getSchemeName().equals(serverProtocol.getSchemeName()) && !Protocol.SIPS.getSchemeName().equals(serverProtocol.getSchemeName())) {
            Context.getCurrentLogger().info("Couldn't find the mandatory \"Host\" HTTP header.");
        }
        Protocol protocol = (Protocol)((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.getSchemeName()).append("://");
        sb.append(hostDomain);
        if (hostPort != -1 && hostPort != protocol.getDefaultPort()) {
            sb.append(':').append(hostPort);
        }
        this.setHostRef(sb.toString());
        if (this.resourceUri != null) {
            this.setResourceRef(new Reference(this.getHostRef(), this.resourceUri));
            if (this.getResourceRef().isRelative()) {
                if (!this.resourceUri.startsWith("/")) {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + "/" + this.resourceUri));
                } else {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + this.resourceUri));
                }
            }
            this.setOriginalRef(this.getResourceRef().getTargetRef());
        }
        String dateHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Date", true);
        Date date = null;
        if (dateHeader != null) {
            date = DateUtils.parse((String)dateHeader);
        }
        if (date == null) {
            date = new Date();
        }
        this.setDate(date);
        String string = maxForwardsHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Max-Forwards", true);
        if (maxForwardsHeader != null) {
            try {
                this.setMaxForwards(Integer.parseInt(maxForwardsHeader));
            }
            catch (NumberFormatException nfe) {
                Context.getCurrentLogger().info("Unable to parse the Max-Forwards header: " + maxForwardsHeader);
            }
        }
        String string2 = callIdHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Call-ID", true);
        if (callIdHeader != null) {
            this.setCallId(callIdHeader);
        }
        String string3 = callSeqHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("CSeq", true);
        if (callSeqHeader != null) {
            this.setCommandSequence(callSeqHeader);
        }
        String string4 = toHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("To", true);
        if (toHeader != null) {
            try {
                this.setTo(new AddressReader(toHeader).readValue());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String string5 = fromHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("From", true);
        if (fromHeader != null) {
            try {
                this.setFrom(new AddressReader(fromHeader).readValue());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String mimeVersionHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("MIME-Version", true);
        this.setMimeVersion(mimeVersionHeader);
        String organizationHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Organization", true);
        this.setOrganization(organizationHeader);
        String subjectHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Subject", true);
        this.setSubject(subjectHeader);
    }

    @Override
    public void setInReplyTo(List<String> inReplyTo) {
        super.setInReplyTo(inReplyTo);
        this.inReplyToAdded = true;
    }

    @Override
    public void setPriority(Priority priority) {
        super.setPriority(priority);
        this.priorityAdded = true;
    }

    public void setProxyChallengeResponse(ChallengeResponse response) {
        super.setProxyChallengeResponse(response);
        this.proxySecurityAdded = true;
    }

    @Override
    public void setProxyRequires(List<OptionTag> proxyRequires) {
        super.setProxyRequires(proxyRequires);
        this.proxyRequiresAdded = true;
    }

    public void setRecipientsInfo(List<RecipientInfo> recipientsInfo) {
        super.setRecipientsInfo(recipientsInfo);
        this.recipientsInfoAdded = true;
    }

    @Override
    public void setRecordedRoutes(List<Address> recordedRoutes) {
        super.setRecordedRoutes(recordedRoutes);
        this.recordedRoutesAdded = true;
    }

    @Override
    public void setReferTo(Address referTo) {
        super.setReferTo(referTo);
        this.referToAdded = true;
    }

    @Override
    public void setReplyTo(Address replyTo) {
        super.setReplyTo(replyTo);
        this.replyToAdded = true;
    }

    @Override
    public void setRequires(List<OptionTag> requires) {
        super.setRequires(requires);
        this.requiresAdded = true;
    }

    @Override
    public void setRoutes(List<Address> routes) {
        super.setRoutes(routes);
        this.routesAdded = true;
    }

    @Override
    public void setSipIfMatch(Tag sipIfMatch) {
        super.setSipIfMatch(sipIfMatch);
        this.sipIfMatchAdded = true;
    }

    @Override
    public void setSipRecipientsInfo(List<SipRecipientInfo> recipientsInfo) {
        super.setSipRecipientsInfo(recipientsInfo);
        this.recipientsInfoAdded = true;
    }

    @Override
    public void setSubscriptionState(Subscription subscription) {
        super.setSubscriptionState(subscription);
        this.subscriptionAdded = true;
    }

    @Override
    public void setSupported(List<OptionTag> supported) {
        super.setSupported(supported);
        this.supportedAdded = true;
    }

    public void setWarnings(List<Warning> warnings) {
        super.setWarnings(warnings);
        this.warningsAdded = true;
    }
}

