/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.util.logging.Level;
import org.restlet.Response;
import org.restlet.data.Header;
import org.restlet.data.Tag;
import org.restlet.engine.header.TagWriter;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.way.ClientOutboundWay;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.SipRequest;
import org.restlet.ext.sip.SipResponse;
import org.restlet.ext.sip.internal.AddressWriter;
import org.restlet.ext.sip.internal.ContactInfoWriter;
import org.restlet.ext.sip.internal.EventTypeWriter;
import org.restlet.ext.sip.internal.EventWriter;
import org.restlet.ext.sip.internal.OptionTagWriter;
import org.restlet.ext.sip.internal.SipClientHelper;
import org.restlet.ext.sip.internal.SipRecipientInfoWriter;
import org.restlet.ext.sip.internal.SubscriptionWriter;
import org.restlet.util.Series;

public class SipClientOutboundWay
extends ClientOutboundWay {
    public SipClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    protected void addGeneralHeaders(Series<Header> headers) {
        SipRequest sipRequest;
        if (this.getMessage().getRequest() instanceof SipRequest && !(sipRequest = (SipRequest)this.getMessage().getRequest()).getSipRecipientsInfo().isEmpty()) {
            for (SipRecipientInfo recipient : sipRequest.getSipRecipientsInfo()) {
                headers.add("Via", SipRecipientInfoWriter.write(recipient));
            }
        }
        super.addGeneralHeaders(headers);
    }

    protected void addRequestHeaders(Series<Header> headers) {
        SipRequest sipRequest = null;
        if (this.getMessage().getRequest() instanceof SipRequest) {
            sipRequest = (SipRequest)this.getMessage().getRequest();
            if (sipRequest.getCallId() != null) {
                headers.add("Call-ID", sipRequest.getCallId());
            }
            if (sipRequest.getCommandSequence() != null) {
                headers.add("CSeq", sipRequest.getCommandSequence());
            }
            if (sipRequest.getFrom() != null) {
                headers.add("From", AddressWriter.write(sipRequest.getFrom()));
            }
            if (sipRequest.getTo() != null) {
                headers.add("To", AddressWriter.write(sipRequest.getTo()));
            }
            if (sipRequest.getAlertInfo() != null) {
                headers.add("Alert-Info", AddressWriter.write(sipRequest.getAlertInfo()));
            }
            if (!sipRequest.getAllowedEventTypes().isEmpty()) {
                headers.add("Allow-Events", EventTypeWriter.write(sipRequest.getAllowedEventTypes()));
            }
            if (!sipRequest.getCallerInfo().isEmpty()) {
                headers.add("Call-Info", AddressWriter.write(sipRequest.getCallerInfo()));
            }
            if (!sipRequest.getContacts().isEmpty()) {
                headers.add("Contact", ContactInfoWriter.write(sipRequest.getContacts()));
            }
            if (sipRequest.getEvent() != null) {
                headers.add("Event", EventWriter.write(sipRequest.getEvent()));
            }
            if (sipRequest.getMimeVersion() != null) {
                headers.add("MIME-Version", sipRequest.getMimeVersion());
            }
            if (sipRequest.getOrganization() != null) {
                headers.add("Organization", sipRequest.getOrganization());
            }
            if (!sipRequest.getRecordedRoutes().isEmpty()) {
                headers.add("Record-Route", AddressWriter.write(sipRequest.getRecordedRoutes()));
            }
            if (sipRequest.getReplyTo() != null) {
                headers.add("Reply-To", AddressWriter.write(sipRequest.getReplyTo()));
            }
            if (!sipRequest.getSupported().isEmpty()) {
                headers.add("Supported", OptionTagWriter.write(sipRequest.getSupported()));
            }
            if (!sipRequest.getInReplyTo().isEmpty()) {
                StringBuilder sb = new StringBuilder(sipRequest.getInReplyTo().get(0));
                for (int i = 1; i < sipRequest.getInReplyTo().size(); ++i) {
                    sb.append(",").append(sipRequest.getInReplyTo().get(i));
                }
                headers.add("In-Reply-To", sb.toString());
            }
            if (sipRequest.getPriority() != null) {
                headers.add("Priority", sipRequest.getPriority().getValue());
            }
            if (!sipRequest.getProxyRequires().isEmpty()) {
                headers.add("Proxy-Require", OptionTagWriter.write(sipRequest.getProxyRequires()));
            }
            if (sipRequest.getReferTo() != null) {
                headers.add("Refer-To", AddressWriter.write(sipRequest.getReferTo()));
            }
            if (!sipRequest.getRequires().isEmpty()) {
                headers.add("Require", OptionTagWriter.write(sipRequest.getProxyRequires()));
            }
            if (!sipRequest.getRoutes().isEmpty()) {
                headers.add("Route", AddressWriter.write(sipRequest.getRoutes()));
            }
            if (sipRequest.getSipIfMatch() != null) {
                headers.add("If-Match", TagWriter.write((Tag)sipRequest.getSipIfMatch()));
            }
            if (sipRequest.getSubject() != null) {
                headers.add("Subject", sipRequest.getSubject());
            }
            if (sipRequest.getSubscriptionState() != null) {
                headers.add("Subscription-State", SubscriptionWriter.write(sipRequest.getSubscriptionState()));
            }
        }
        super.addRequestHeaders(headers);
    }

    public SipClientHelper getHelper() {
        return (SipClientHelper)super.getHelper();
    }

    public void handle(Response response) {
        if (this.getMessage() == null && response != null) {
            SipResponse sipResponse = (SipResponse)response;
            SipRequest request = (SipRequest)sipResponse.getRequest();
            String tid = request.getTransaction();
            this.getHelper().getRequests().put(tid, request);
            request.updateLastActivity();
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Handling outbound request: " + (Object)((Object)request));
            }
            this.setMessage(sipResponse);
            this.setIoState(IoState.INTEREST);
        }
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.getMessage() == null;
    }
}

