/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.util.List;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.util.NamedValue;

public class SipRecipientInfoWriter
extends HeaderWriter<SipRecipientInfo> {
    public static String write(List<SipRecipientInfo> recipientsInfo) {
        return new SipRecipientInfoWriter().append(recipientsInfo).toString();
    }

    public static String write(SipRecipientInfo recipientInfo) {
        return new SipRecipientInfoWriter().append(recipientInfo).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipRecipientInfoWriter append(SipRecipientInfo recipientInfo) {
        if (recipientInfo.getProtocol() == null) throw new IllegalArgumentException("The protocol of a recipient can't be null");
        this.appendToken(recipientInfo.getProtocol().getName());
        this.append('/');
        this.appendToken(recipientInfo.getProtocol().getVersion());
        if (recipientInfo.getTransport() != null) {
            this.append('/');
            this.appendToken(recipientInfo.getTransport());
        }
        this.appendSpace();
        if (recipientInfo.getName() == null) throw new IllegalArgumentException("The name (host or pseudonym) of a recipient can't be null");
        this.append(recipientInfo.getName());
        if (!recipientInfo.getParameters().isEmpty()) {
            for (Parameter param : recipientInfo.getParameters()) {
                this.appendParameterSeparator();
                this.appendExtension((NamedValue)param);
            }
        }
        if (recipientInfo.getComment() == null) return this;
        this.appendSpace();
        this.appendComment(recipientInfo.getComment());
        return this;
    }
}

