/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip;

import org.restlet.data.Status;

public final class SipStatus {
    private static final String BASE_SIP = "http://tools.ietf.org/html/rfc3261#section-21";
    public static final Status CLIENT_ERROR_ADDRESS_INCOMPLETE = new Status(484, "Address Incomplete", "The Request-URI was incomplete", "http://tools.ietf.org/html/rfc3261#section-21.4.23");
    public static final Status CLIENT_ERROR_AMBIGUOUS = new Status(485, "Ambiguous", "The Request-URI was ambiguous", "http://tools.ietf.org/html/rfc3261#section-21.4.24");
    public static final Status CLIENT_ERROR_BAD_EXTENSION = new Status(420, "Bad Extension", "The server did not understand the protocol extension", "http://tools.ietf.org/html/rfc3261#section-21.4.15");
    public static final Status CLIENT_ERROR_BAD_REQUEST = new Status(400, "Bad Request", "The request could not be understood due to malformed syntax", "http://tools.ietf.org/html/rfc3261#section-21.4.1");
    public static final Status CLIENT_ERROR_BUSY_HERE = new Status(486, "Busy Here", "The callee is currently not willing or able to take additional calls", "http://tools.ietf.org/html/rfc3261#section-21.4.25");
    public static final Status CLIENT_ERROR_CALL_DOESNT_EXIST = new Status(481, "Call/Transaction Does Not Exist", "The UAS received a request that does not match any existing dialog or transaction.", "http://tools.ietf.org/html/rfc3261#section-21.4.19");
    public static final Status CLIENT_ERROR_EXTENSION_REQUIRED = new Status(421, "Extension Required", "The UAS needs a particular extension to process the request", "http://tools.ietf.org/html/rfc3261#section-21.4.16");
    public static final Status CLIENT_ERROR_FORBIDDEN = new Status(403, "Forbidden", "The server understood the request, but is refusing to fulfill it", "http://tools.ietf.org/html/rfc3261#section-21.4.4");
    public static final Status CLIENT_ERROR_GONE = new Status(410, "Gone", "The requested resource is no longer available", "http://tools.ietf.org/html/rfc3261#section-21.4.10");
    public static final Status CLIENT_ERROR_INTERVAL_TOO_BRIEF = new Status(423, "Interval Too Brief", "The expiration time of the resource refreshed by the request is too short", "http://tools.ietf.org/html/rfc3261#section-21.4.17");
    public static final Status CLIENT_ERROR_LOOP_DETECTED = new Status(482, "Loop Detected", "The server has detected a loop", "http://tools.ietf.org/html/rfc3261#section-21.4.20");
    public static final Status CLIENT_ERROR_METHOD_NOT_ALLOWED = new Status(405, "Method Not Allowed", "The method is understood, but not allowed for the given request URI", "http://tools.ietf.org/html/rfc3261#section-21.4.6");
    public static final Status CLIENT_ERROR_NOT_ACCEPTABLE = new Status(406, "Not Acceptable", "The resource is not capable of generating acceptable entities", "http://tools.ietf.org/html/rfc3261#section-21.4.7");
    public static final Status CLIENT_ERROR_NOT_ACCEPTABLE_HERE = new Status(488, "Not Acceptable Here", "Some aspects of the requested resource were not acceptable", "http://tools.ietf.org/html/rfc3261#section-21.4.27");
    public static final Status CLIENT_ERROR_NOT_FOUND = new Status(404, "Not Found", "", "http://tools.ietf.org/html/rfc3261#section-21.4.5");
    public static final Status CLIENT_ERROR_PAYMENT_REQUIRED = new Status(402, "Payment Required", "Reserved for future use", "http://tools.ietf.org/html/rfc3261#section-21.4.3");
    public static final Status CLIENT_ERROR_PROXY_AUTHENTIFICATION_REQUIRED = new Status(407, "Proxy Authentication Required", "The client must first authenticate itself with the proxy.", "http://tools.ietf.org/html/rfc3261#section-21.4.8");
    public static final Status CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE = new Status(413, "Request Entity Too Large", "The server is refusing to process because the entity-body is larger than the server is willing or able to process", "http://tools.ietf.org/html/rfc3261#section-21.4.11");
    public static final Status CLIENT_ERROR_REQUEST_PENDING = new Status(491, "Request Pending", "The request was received by a UAS that had a pending request within the same dialog", "http://tools.ietf.org/html/rfc3261#section-21.4.28");
    public static final Status CLIENT_ERROR_REQUEST_TERMINATED = new Status(487, "Request Terminated", "The request was terminated by a BYE or CANCEL request", "http://tools.ietf.org/html/rfc3261#section-21.4.26");
    public static final Status CLIENT_ERROR_REQUEST_TIMEOUT = new Status(408, "Request Timeout", "The server could not produce a response within a suitable amount of time", "http://tools.ietf.org/html/rfc3261#section-21.4.9");
    public static final Status CLIENT_ERROR_REQUEST_UNDECIPHERABLE = new Status(493, "Undecipherable", "Encrypted MIME body for which the recipient does not possess or will not provide an appropriate decryption key", "http://tools.ietf.org/html/rfc3261#section-21.4.29");
    public static final Status CLIENT_ERROR_REQUEST_URI_TOO_LONG = new Status(414, "Request-URI Too Long", "The server is refusing to service the request because the Request-URI is too long", "http://tools.ietf.org/html/rfc3261#section-21.4.12");
    public static final Status CLIENT_ERROR_TEMPORARILY_UNAVAILABLE = new Status(480, "Temporarily Unavailable", "The callee is currently unavailable", "http://tools.ietf.org/html/rfc3261#section-21.4.18");
    public static final Status CLIENT_ERROR_TOO_MANY_HOPS = new Status(483, "Too Many Hops", "Max-Forwards header field received with the value zero", "http://tools.ietf.org/html/rfc3261#section-21.4.21");
    public static final Status CLIENT_ERROR_UNAUTHORIZED = new Status(401, "Unauthorized", "The request requires user authentication", "http://tools.ietf.org/html/rfc3261#section-21.4.2");
    public static final Status CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE = new Status(415, "Unsupported Media Type", "The server is refusing to service the request because the message body of the request is in a format not supported", "http://tools.ietf.org/html/rfc3261#section-21.4.13");
    public static final Status CLIENT_ERROR_UNSUPPORTED_URI_SCHEME = new Status(416, "Unsupported URI Scheme", "The server cannot process the request because the scheme of the URI in the Request-URI is unknown to the server.", "http://tools.ietf.org/html/rfc3261#section-21.4.14");
    public static final Status GLOBAL_ERROR_BUSY_EVERYWHERE = new Status(600, "Busy Everywhere", "The callee is busy and does not wish to take the call at this time", "http://tools.ietf.org/html/rfc3261#section-21.6.1");
    public static final Status GLOBAL_ERROR_DECLINE = new Status(603, "Decline", "The user explicitly does not wish to or cannot participate", "http://tools.ietf.org/html/rfc3261#section-21.6.2");
    public static final Status GLOBAL_ERROR_DOESNT_EXIST_ANYWHERE = new Status(604, "Does Not Exist Anywhere", "The user indicated in the Request-URI does not exist anywhere", "http://tools.ietf.org/html/rfc3261#section-21.6.3");
    public static final Status GLOBAL_ERROR_NOT_ACCEPTABLE = new Status(606, "Not Acceptable", "Some aspects of the session description were not acceptable", "http://tools.ietf.org/html/rfc3261#section-21.6.4");
    public static final Status INFO_CALL_IS_BEING_FORWARDED = new Status(181, "Call Is Being Forwarded", "The call is being forwarded to a different set of destinations", "http://tools.ietf.org/html/rfc3261#section-21.1.3");
    public static final Status INFO_QUEUED = new Status(182, "Queued", "The server has decided to queue the call rather than reject it", "http://tools.ietf.org/html/rfc3261#section-21.1.4");
    public static final Status INFO_RINGING = new Status(180, "Ringing", "The UA receiving the INVITE is trying to alert the user", "http://tools.ietf.org/html/rfc3261#section-21.1.2");
    public static final Status INFO_SESSION_PROGRESS = new Status(183, "Session Progress", "Conveys information about the progress of the call that is not otherwise classified", "http://tools.ietf.org/html/rfc3261#section-21.1.5");
    public static final Status INFO_TRYING = new Status(100, "Trying", "The request has been received and some unspecified action is being taken", "http://tools.ietf.org/html/rfc3261#section-21.1.1");
    public static final Status REDIRECTION_ALTERNATIVE_SERVICE = new Status(380, "Alternative Service", "The call was not successful, but alternative services are possible", "http://tools.ietf.org/html/rfc3261#section-21.3.5");
    public static final Status REDIRECTION_MOVED_PERMANENTLY = new Status(301, "Moved Permanently", "The user can no longer be found at the given address", "http://tools.ietf.org/html/rfc3261#section-21.3.2");
    public static final Status REDIRECTION_MOVED_TEMPORARILY = new Status(302, "Moved Temporarily", "Please retry the request at the new given address ", "http://tools.ietf.org/html/rfc3261#section-21.3.3");
    public static final Status REDIRECTION_MULTIPLE_CHOICES = new Status(300, "Multiple Choices", "The address in the request resolved to several choices", "http://tools.ietf.org/html/rfc3261#section-21.3.1");
    public static final Status REDIRECTION_USE_PROXY = new Status(305, "Use Proxy", "The requested resource MUST be accessed through the proxy", "http://tools.ietf.org/html/rfc3261#section-21.3.4");
    public static final Status SERVER_ERROR_BAD_GATEWAY = new Status(502, "Bad Gateway", "The server received an invalid response from the downstream server", "http://tools.ietf.org/html/rfc3261#section-21.5.3");
    public static final Status SERVER_ERROR_INTERNAL = new Status(500, "Server Internal Error", "The server encountered an unexpected condition that prevented it from fulfilling the request", "http://tools.ietf.org/html/rfc3261#section-21.5.1");
    public static final Status SERVER_ERROR_MESSAGE_TOO_LARGE = new Status(513, "Message Too Large", "The server was unable to process the request since the message length exceeded its capabilities", "http://tools.ietf.org/html/rfc3261#section-21.5.7");
    public static final Status SERVER_ERROR_NOT_IMPLEMENTED = new Status(501, "Not Implemented", "The server does not support the functionality required to fulfill the request", "http://tools.ietf.org/html/rfc3261#section-21.5.2");
    public static final Status SERVER_ERROR_SERVER_TIMEOUT = new Status(504, "Server Time-out", "The server did not receive a timely response from an external server", "http://tools.ietf.org/html/rfc3261#section-21.5.5");
    public static final Status SERVER_ERROR_SERVICE_UNAVAILABLE = new Status(503, "Service Unavailable", "The server is temporarily unable to process the request", "http://tools.ietf.org/html/rfc3261#section-21.5.4");
    public static final Status SERVER_ERROR_VERSION_NOT_SUPPORTED = new Status(505, "Version Not Supported", "The server does not support, or refuses to support, the SIP protocol version that was used", "http://tools.ietf.org/html/rfc3261#section-21.5.6");
    public static final Status SUCCESS_OK = new Status(200, "Success", "The request has succeeded", "http://tools.ietf.org/html/rfc3261#section-21.2.1");

    public static Status valueOf(int code) {
        Status result = null;
        switch (code) {
            case 100: {
                result = INFO_TRYING;
                break;
            }
            case 180: {
                result = INFO_RINGING;
                break;
            }
            case 181: {
                result = INFO_CALL_IS_BEING_FORWARDED;
                break;
            }
            case 182: {
                result = INFO_QUEUED;
                break;
            }
            case 183: {
                result = INFO_SESSION_PROGRESS;
                break;
            }
            case 200: {
                result = SUCCESS_OK;
                break;
            }
            case 300: {
                result = REDIRECTION_MULTIPLE_CHOICES;
                break;
            }
            case 301: {
                result = REDIRECTION_MOVED_PERMANENTLY;
                break;
            }
            case 302: {
                result = REDIRECTION_MOVED_TEMPORARILY;
                break;
            }
            case 305: {
                result = REDIRECTION_USE_PROXY;
                break;
            }
            case 380: {
                result = REDIRECTION_ALTERNATIVE_SERVICE;
                break;
            }
            case 400: {
                result = CLIENT_ERROR_BAD_REQUEST;
                break;
            }
            case 401: {
                result = CLIENT_ERROR_UNAUTHORIZED;
                break;
            }
            case 402: {
                result = CLIENT_ERROR_PAYMENT_REQUIRED;
                break;
            }
            case 403: {
                result = CLIENT_ERROR_FORBIDDEN;
                break;
            }
            case 404: {
                result = CLIENT_ERROR_NOT_FOUND;
                break;
            }
            case 405: {
                result = CLIENT_ERROR_METHOD_NOT_ALLOWED;
                break;
            }
            case 406: {
                result = CLIENT_ERROR_NOT_ACCEPTABLE;
                break;
            }
            case 407: {
                result = CLIENT_ERROR_PROXY_AUTHENTIFICATION_REQUIRED;
                break;
            }
            case 408: {
                result = CLIENT_ERROR_REQUEST_TIMEOUT;
                break;
            }
            case 410: {
                result = CLIENT_ERROR_GONE;
                break;
            }
            case 413: {
                result = CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE;
                break;
            }
            case 414: {
                result = CLIENT_ERROR_REQUEST_URI_TOO_LONG;
                break;
            }
            case 415: {
                result = CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE;
                break;
            }
            case 416: {
                result = CLIENT_ERROR_UNSUPPORTED_URI_SCHEME;
                break;
            }
            case 420: {
                result = CLIENT_ERROR_BAD_EXTENSION;
                break;
            }
            case 421: {
                result = CLIENT_ERROR_EXTENSION_REQUIRED;
                break;
            }
            case 423: {
                result = CLIENT_ERROR_INTERVAL_TOO_BRIEF;
                break;
            }
            case 480: {
                result = CLIENT_ERROR_TEMPORARILY_UNAVAILABLE;
                break;
            }
            case 481: {
                result = CLIENT_ERROR_CALL_DOESNT_EXIST;
                break;
            }
            case 482: {
                result = CLIENT_ERROR_LOOP_DETECTED;
                break;
            }
            case 483: {
                result = CLIENT_ERROR_TOO_MANY_HOPS;
                break;
            }
            case 484: {
                result = CLIENT_ERROR_ADDRESS_INCOMPLETE;
                break;
            }
            case 485: {
                result = CLIENT_ERROR_AMBIGUOUS;
                break;
            }
            case 486: {
                result = CLIENT_ERROR_BUSY_HERE;
                break;
            }
            case 487: {
                result = CLIENT_ERROR_REQUEST_TERMINATED;
                break;
            }
            case 488: {
                result = CLIENT_ERROR_NOT_ACCEPTABLE_HERE;
                break;
            }
            case 491: {
                result = CLIENT_ERROR_REQUEST_PENDING;
                break;
            }
            case 493: {
                result = CLIENT_ERROR_REQUEST_UNDECIPHERABLE;
                break;
            }
            case 500: {
                result = SERVER_ERROR_INTERNAL;
                break;
            }
            case 501: {
                result = SERVER_ERROR_NOT_IMPLEMENTED;
                break;
            }
            case 502: {
                result = SERVER_ERROR_BAD_GATEWAY;
                break;
            }
            case 503: {
                result = SERVER_ERROR_SERVICE_UNAVAILABLE;
                break;
            }
            case 504: {
                result = SERVER_ERROR_SERVER_TIMEOUT;
                break;
            }
            case 505: {
                result = SERVER_ERROR_VERSION_NOT_SUPPORTED;
                break;
            }
            case 513: {
                result = SERVER_ERROR_MESSAGE_TOO_LARGE;
                break;
            }
            case 600: {
                result = GLOBAL_ERROR_BUSY_EVERYWHERE;
                break;
            }
            case 603: {
                result = GLOBAL_ERROR_DECLINE;
                break;
            }
            case 604: {
                result = GLOBAL_ERROR_DOESNT_EXIST_ANYWHERE;
                break;
            }
            case 606: {
                result = GLOBAL_ERROR_NOT_ACCEPTABLE;
                break;
            }
            default: {
                result = Status.valueOf((int)code);
            }
        }
        return result;
    }
}

