/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.ContactInfo;
import org.restlet.ext.sip.Event;
import org.restlet.ext.sip.EventType;
import org.restlet.ext.sip.OptionTag;
import org.restlet.ext.sip.Priority;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.Subscription;
import org.restlet.ext.sip.internal.AddressWriter;
import org.restlet.representation.Representation;

@Deprecated
public class SipRequest
extends Request {
    private static final int DEFAULT_TIMEOUT = 32000;
    private volatile Address alertInfo;
    private volatile List<EventType> allowedEventTypes;
    private volatile List<Address> callerInfo;
    private volatile String callId;
    private volatile String commandSequence;
    private volatile List<ContactInfo> contacts;
    private final long creation;
    private volatile Event event;
    private volatile Address from;
    private volatile boolean handled;
    private volatile List<String> inReplyTo;
    private volatile long lastActivity;
    private final int maxIdleTimeMs;
    private volatile String mimeVersion;
    private volatile String organization;
    private volatile Priority priority;
    private volatile List<OptionTag> proxyRequires;
    private volatile List<SipRecipientInfo> recipientsInfo;
    private volatile List<Address> recordedRoutes;
    private volatile Address referTo;
    private volatile Address replyTo;
    private volatile List<OptionTag> requires;
    private volatile List<Address> routes;
    private volatile Tag sipIfMatch;
    private volatile String subject;
    private volatile Subscription subscription;
    private volatile List<OptionTag> supported;
    private volatile Address to;

    public SipRequest() {
        this((Method)null, (Reference)null, (Representation)null);
    }

    public SipRequest(Method method, Reference resourceRef) {
        this(method, resourceRef, null);
    }

    public SipRequest(Method method, Reference resourceRef, Representation entity) {
        super(method, resourceRef, entity);
        this.lastActivity = this.creation = System.currentTimeMillis();
        this.maxIdleTimeMs = 32000;
        this.handled = false;
    }

    public SipRequest(Method method, String resourceUri) {
        this(method, new Reference(resourceUri));
    }

    public SipRequest(Method method, String resourceUri, Representation entity) {
        this(method, new Reference(resourceUri), entity);
    }

    public SipRequest(SipRequest request) {
        super((Request)request);
        this.alertInfo = request.getAlertInfo();
        this.allowedEventTypes = request.getAllowedEventTypes();
        this.callerInfo = request.getCallerInfo();
        this.callId = request.getCallId();
        this.commandSequence = request.getCommandSequence();
        this.contacts = request.getContacts();
        this.event = request.getEvent();
        this.from = request.getFrom();
        this.inReplyTo = request.getInReplyTo();
        this.mimeVersion = request.getMimeVersion();
        this.organization = request.getOrganization();
        this.priority = request.getPriority();
        this.proxyRequires = request.getProxyRequires();
        this.recipientsInfo = request.getSipRecipientsInfo();
        this.recordedRoutes = request.getRecordedRoutes();
        this.referTo = request.getReferTo();
        this.replyTo = request.getReplyTo();
        this.requires = request.getRequires();
        this.routes = request.getRoutes();
        this.sipIfMatch = request.getSipIfMatch();
        this.subject = request.getSubject();
        this.subscription = request.getSubscriptionState();
        this.supported = request.getSupported();
        this.to = request.getTo();
        this.lastActivity = this.creation = System.currentTimeMillis();
        this.maxIdleTimeMs = request.getMaxIdleTimeMs();
    }

    public Address getAlertInfo() {
        return this.alertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventType> getAllowedEventTypes() {
        List<EventType> aet = this.allowedEventTypes;
        if (aet == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                aet = this.allowedEventTypes;
                if (aet == null) {
                    this.allowedEventTypes = aet = new CopyOnWriteArrayList<EventType>();
                }
            }
        }
        return aet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getCallerInfo() {
        List<Address> ci = this.callerInfo;
        if (ci == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                ci = this.callerInfo;
                if (ci == null) {
                    this.callerInfo = ci = new CopyOnWriteArrayList<Address>();
                }
            }
        }
        return ci;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getCommandSequence() {
        return this.commandSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContactInfo> getContacts() {
        List<ContactInfo> c = this.contacts;
        if (c == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                c = this.contacts;
                if (c == null) {
                    this.contacts = c = new CopyOnWriteArrayList<ContactInfo>();
                }
            }
        }
        return c;
    }

    public long getCreation() {
        return this.creation;
    }

    public Event getEvent() {
        return this.event;
    }

    public Address getFrom() {
        return this.from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInReplyTo() {
        List<String> irt = this.inReplyTo;
        if (irt == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                irt = this.inReplyTo;
                if (irt == null) {
                    this.inReplyTo = irt = new CopyOnWriteArrayList<String>();
                }
            }
        }
        return irt;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public int getMaxIdleTimeMs() {
        return this.maxIdleTimeMs;
    }

    public String getMimeVersion() {
        return this.mimeVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Priority getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionTag> getProxyRequires() {
        List<OptionTag> pr = this.proxyRequires;
        if (pr == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                pr = this.proxyRequires;
                if (pr == null) {
                    this.proxyRequires = pr = new CopyOnWriteArrayList<OptionTag>();
                }
            }
        }
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getRecordedRoutes() {
        List<Address> rr = this.recordedRoutes;
        if (rr == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                rr = this.recordedRoutes;
                if (rr == null) {
                    this.recordedRoutes = rr = new CopyOnWriteArrayList<Address>();
                }
            }
        }
        return rr;
    }

    public Address getReferTo() {
        return this.referTo;
    }

    public Address getReplyTo() {
        return this.replyTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionTag> getRequires() {
        List<OptionTag> r = this.requires;
        if (r == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                r = this.requires;
                if (r == null) {
                    this.requires = r = new CopyOnWriteArrayList<OptionTag>();
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getRoutes() {
        List<Address> r = this.routes;
        if (r == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                r = this.routes;
                if (r == null) {
                    this.routes = r = new CopyOnWriteArrayList<Address>();
                }
            }
        }
        return r;
    }

    public Tag getSipIfMatch() {
        return this.sipIfMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SipRecipientInfo> getSipRecipientsInfo() {
        List<SipRecipientInfo> sri = this.recipientsInfo;
        if (sri == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                sri = this.recipientsInfo;
                if (sri == null) {
                    this.recipientsInfo = sri = new CopyOnWriteArrayList<SipRecipientInfo>();
                }
            }
        }
        return sri;
    }

    public String getSubject() {
        return this.subject;
    }

    public Subscription getSubscriptionState() {
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionTag> getSupported() {
        List<OptionTag> s = this.supported;
        if (s == null) {
            SipRequest sipRequest = this;
            synchronized (sipRequest) {
                s = this.supported;
                if (s == null) {
                    this.supported = s = new CopyOnWriteArrayList<OptionTag>();
                }
            }
        }
        return s;
    }

    public Address getTo() {
        return this.to;
    }

    public String getTransaction() {
        String result = null;
        if (this.getSipRecipientsInfo().size() > 0) {
            SipRecipientInfo recipient = this.getSipRecipientsInfo().get(0);
            result = recipient.getParameters().getFirstValue("branch");
        } else {
            result = this.getCallId() + '|' + this.getCommandSequence() + '|' + AddressWriter.write(this.getTo(), false) + '|' + AddressWriter.write(this.getFrom()) + '|';
        }
        return result;
    }

    public boolean hasTimedOut() {
        return System.currentTimeMillis() - this.lastActivity >= (long)this.getMaxIdleTimeMs();
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setAlertInfo(Address alertInfo) {
        this.alertInfo = alertInfo;
    }

    public void setAllowedEventTypes(List<EventType> allowedEventTypes) {
        this.allowedEventTypes = allowedEventTypes;
    }

    public void setCallerInfo(List<Address> callerInfo) {
        this.callerInfo = callerInfo;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setCommandSequence(String commandSequence) {
        this.commandSequence = commandSequence;
    }

    public void setContacts(List<ContactInfo> contact) {
        this.contacts = contact;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public void setInReplyTo(List<String> inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    private void setLastActivity(long lastActivityTime) {
        this.lastActivity = lastActivityTime;
    }

    public void setMimeVersion(String mimeVersion) {
        this.mimeVersion = mimeVersion;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setProxyRequires(List<OptionTag> proxyRequires) {
        this.proxyRequires = proxyRequires;
    }

    public void setRecordedRoutes(List<Address> recordedRoutes) {
        this.recordedRoutes = recordedRoutes;
    }

    public void setReferTo(Address referTo) {
        this.referTo = referTo;
    }

    public void setReplyTo(Address replyTo) {
        this.replyTo = replyTo;
    }

    public void setRequires(List<OptionTag> requires) {
        this.requires = requires;
    }

    public void setRoutes(List<Address> routes) {
        this.routes = routes;
    }

    public void setSipIfMatch(Tag sipIfMatch) {
        this.sipIfMatch = sipIfMatch;
    }

    public void setSipRecipientsInfo(List<SipRecipientInfo> recipientsInfo) {
        this.recipientsInfo = recipientsInfo;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSubscriptionState(Subscription subscription) {
        this.subscription = subscription;
    }

    public void setSupported(List<OptionTag> supported) {
        this.supported = supported;
    }

    public void setTo(Address to) {
        this.to = to;
    }

    public void updateLastActivity() {
        this.setLastActivity(System.currentTimeMillis());
    }
}

