/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Protocol;
import org.restlet.ext.nio.ClientConnectionHelper;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.way.InboundWay;
import org.restlet.ext.nio.internal.way.OutboundWay;
import org.restlet.ext.sip.SipRequest;
import org.restlet.ext.sip.SipResponse;
import org.restlet.ext.sip.SipStatus;
import org.restlet.ext.sip.internal.SipClientInboundWay;
import org.restlet.ext.sip.internal.SipClientOutboundWay;

@Deprecated
public class SipClientHelper
extends ClientConnectionHelper {
    private final Map<String, SipRequest> requests = new ConcurrentHashMap<String, SipRequest>();

    public SipClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.SIP);
        this.getProtocols().add(Protocol.SIPS);
    }

    public boolean control() {
        boolean result = super.control();
        Iterator<SipRequest> iter = this.getRequests().values().iterator();
        while (iter.hasNext()) {
            Level level;
            SipRequest request = iter.next();
            if (!request.hasTimedOut()) continue;
            if (request.isHandled() || !request.isExpectingResponse()) {
                level = Level.FINE;
            } else {
                level = Level.INFO;
                SipResponse response = new SipResponse(request);
                response.setStatus(SipStatus.CLIENT_ERROR_REQUEST_TIMEOUT, "The SIP client connector has timeout due to lack of activity on this transaction: " + request.getTransaction());
                this.handleInbound(response, false);
            }
            this.getLogger().log(level, "This SIP transaction has timed out: " + request.getTransaction());
            iter.remove();
        }
        return result;
    }

    public InboundWay createInboundWay(Connection<Client> connection, int bufferSize) {
        return new SipClientInboundWay(connection, bufferSize);
    }

    public OutboundWay createOutboundWay(Connection<Client> connection, int bufferSize) {
        return new SipClientOutboundWay(connection, bufferSize);
    }

    public Request getRequest(Response response) {
        Request result = null;
        if (response != null && (result = response.getRequest()) == null) {
            SipResponse sipResponse = (SipResponse)response;
            String tid = sipResponse.getTransactionId();
            result = this.getRequests().get(tid);
        }
        return result;
    }

    public Map<String, SipRequest> getRequests() {
        return this.requests;
    }

    protected void unblock(Response response) {
        if (response.getRequest() != null) {
            SipRequest request = (SipRequest)response.getRequest();
            request.setHandled(true);
            CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get("org.restlet.engine.connector.latch");
            if (latch == null) {
                this.getLogger().warning("Final response ignored: " + response);
            }
        }
        super.unblock(response);
    }
}

