/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import java.util.ArrayList;
import java.util.List;
import org.restlet.ext.swagger.DocumentationInfo;
import org.restlet.ext.swagger.DocumentedInfo;
import org.restlet.ext.swagger.LinkInfo;
import org.restlet.ext.swagger.OptionInfo;
import org.restlet.ext.swagger.ParameterStyle;

public class ParameterInfo
extends DocumentedInfo {
    private String defaultValue;
    private String fixed;
    private String identifier;
    private LinkInfo link;
    private String name;
    private List<OptionInfo> options;
    private String path;
    private boolean repeating;
    private boolean required;
    private ParameterStyle style;
    private String type;

    public ParameterInfo() {
    }

    public ParameterInfo(String name, ParameterStyle style, DocumentationInfo documentation) {
        super(documentation);
        this.name = name;
        this.style = style;
    }

    public ParameterInfo(String name, ParameterStyle style, List<DocumentationInfo> documentations) {
        super(documentations);
        this.name = name;
        this.style = style;
    }

    public ParameterInfo(String name, ParameterStyle style, String documentation) {
        super(documentation);
        this.name = name;
        this.style = style;
    }

    public ParameterInfo(String name, boolean required, String type, ParameterStyle style, String documentation) {
        super(documentation);
        this.name = name;
        this.required = required;
        this.style = style;
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixed() {
        return this.fixed;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public LinkInfo getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionInfo> getOptions() {
        List<OptionInfo> o = this.options;
        if (o == null) {
            ParameterInfo parameterInfo = this;
            synchronized (parameterInfo) {
                o = this.options;
                if (o == null) {
                    this.options = o = new ArrayList<OptionInfo>();
                }
            }
        }
        return o;
    }

    public String getPath() {
        return this.path;
    }

    public ParameterStyle getStyle() {
        return this.style;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLink(LinkInfo link) {
        this.link = link;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(List<OptionInfo> options) {
        this.options = options;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setStyle(ParameterStyle style) {
        this.style = style;
    }

    public void setType(String type) {
        this.type = type;
    }
}

