/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.swagger.DocumentationInfo;
import org.restlet.ext.swagger.DocumentedInfo;
import org.restlet.ext.swagger.ParameterInfo;
import org.restlet.representation.Variant;

public class RepresentationInfo
extends DocumentedInfo {
    private String identifier;
    private MediaType mediaType;
    private List<ParameterInfo> parameters;
    private List<Reference> profiles;
    private String reference;

    public RepresentationInfo() {
    }

    public RepresentationInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public RepresentationInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public RepresentationInfo(MediaType mediaType) {
        this.setMediaType(mediaType);
    }

    public RepresentationInfo(String documentation) {
        super(documentation);
    }

    public RepresentationInfo(Variant variant) {
        this.setMediaType(variant.getMediaType());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getProfiles() {
        List<Reference> p = this.profiles;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.profiles;
                if (p == null) {
                    this.profiles = p = new ArrayList<Reference>();
                }
            }
        }
        return p;
    }

    public String getReference() {
        return this.reference;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setProfiles(List<Reference> profiles) {
        this.profiles = profiles;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

