/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.swagger.SwaggerApplication;
import org.restlet.representation.Representation;

public class SwaggerComponent
extends Component {
    public static void main(String[] args) throws Exception {
        SwaggerComponent component = new SwaggerComponent();
        for (String arg : args) {
            component.attach(arg);
        }
        component.start();
    }

    public SwaggerComponent() {
    }

    public SwaggerComponent(Reference swaggerRef) {
        this.attach(swaggerRef);
    }

    public SwaggerComponent(Representation swagger) {
        this.attach(swagger);
    }

    public SwaggerComponent(String swaggerUri) {
        this.attach(swaggerUri);
    }

    public SwaggerApplication attach(Reference swaggerRef) {
        Response response;
        SwaggerApplication result = null;
        if (!this.getClients().contains((Object)swaggerRef.getSchemeProtocol())) {
            this.getClients().add(swaggerRef.getSchemeProtocol());
        }
        if ((response = this.getContext().getClientDispatcher().handle(new Request(Method.GET, swaggerRef))).getStatus().isSuccess() && response.isEntityAvailable()) {
            result = this.attach(response.getEntity());
        }
        return result;
    }

    public SwaggerApplication attach(Representation swagger) {
        SwaggerApplication result = new SwaggerApplication(this.getContext().createChildContext(), swagger);
        result.attachToComponent(this);
        return result;
    }

    public SwaggerApplication attach(String swaggerUri) {
        return this.attach(new Reference(swaggerUri));
    }
}

