/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.swagger.ApplicationInfo;
import org.restlet.ext.swagger.SwaggerRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class SwaggerConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_SWAGGER = new VariantInfo(MediaType.APPLICATION_JSON);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_SWAGGER.includes(source)) {
            result = this.addObjectClass(result, ApplicationInfo.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (ApplicationInfo.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_SWAGGER);
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source != null && ApplicationInfo.class.isAssignableFrom(target)) {
            result = 1.0f;
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        if (source instanceof ApplicationInfo) {
            return 1.0f;
        }
        return -1.0f;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        SwaggerRepresentation swaggerSource = null;
        if (source instanceof SwaggerRepresentation) {
            swaggerSource = (SwaggerRepresentation)source;
        }
        T result = null;
        if (target != null && ApplicationInfo.class.isAssignableFrom(target)) {
            result = target.cast(swaggerSource.getApplication());
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        if (source instanceof ApplicationInfo) {
            return new SwaggerRepresentation((ApplicationInfo)source);
        }
        return null;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (ApplicationInfo.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        }
    }
}

